#include <string>
#include <sstream>
#include <iostream>
#include <fstream>
#include <cassert>
#include <cstdlib>
#include <ctime>
#include <limits>
#include <Rcpp.h>
using namespace Rcpp;

// This is a simple example of exporting a C++ function to R. You can
// source this function into an R session using the Rcpp::sourceCpp 
// function (or via the Source button on the editor toolbar). Learn
// more about Rcpp at:
//
//   http://www.rcpp.org/
//   http://adv-r.had.co.nz/Rcpp.html
//   http://gallery.rcpp.org/
//

/*'number-of-candidates' is the number of lines in the file
       'number-of-items' is the number of things being clustered*/

// [[Rcpp::export]]
NumericMatrix lsclu(const char* filename,unsigned long nClusterings, unsigned long nItems) {
  
  bool printMatrix = false;
  unsigned int **b = new unsigned int*[nClusterings];
  for ( unsigned long c=0; c<nClusterings; c++ ) {
    b[c] = new unsigned int[nItems];
    }
  
  std::ifstream clusteringFile;
  clusteringFile.open(filename);
  
  unsigned int label;
  unsigned long count = 0;
  while ( clusteringFile >> label ) {
    b[ count / nItems ][ count % nItems ] = label;
    count++;
  }
  clusteringFile.close();
  assert( count == nClusterings * nItems );
  
  double **pp = new double*[nItems];
  for ( unsigned long i=0; i<nItems; i++ ) {
    pp[i] = new double[i]; //It allocates a nItems double arrays that can each hold nItems doubles Theoretically.
    
    for ( unsigned long j=0; j<i; j++ ) {
      pp[i][j] = 0.0;
    }
  }
  
  for ( unsigned long c=0; c<nClusterings; c++ ) {
    for ( unsigned long i=0; i<nItems; i++ ) {
      for ( unsigned long j=0; j<i; j++ ) {
        if ( b[c][i] == b[c][j] ) pp[i][j]++;
      }
    }
  }
  
  for ( unsigned long i=0; i<nItems; i++ ) {
    for ( unsigned long j=0; j<i; j++ ) {
      pp[i][j] /= (double)nClusterings;                //probability matrix
    }
  }
  
  double minDB = std::numeric_limits<double>::max(); // largest possible value for data type double
  unsigned long minIndex = 0;
  
  for ( unsigned long c=0; c<nClusterings; c++ ) {
    double db = 0.0;
    for ( unsigned long i=0; i<nItems; i++ ) {
      for ( unsigned long j=0; j<i; j++ ) {
        double x = ( b[c][i] == b[c][j] ? 1 : 0 ) - pp[i][j];
        db += x*x;
        
      }
    }
    if ( db < minDB ) {
      minDB = db;
      minIndex = c;
      
      printf("minDB:%f and minIndex = %lu \n", minDB, minIndex);
      
    }
  }

  
  NumericMatrix v( 1 , nItems );
  // Set the number of rows and columns to attribute dim of the vector object.
  // v.attr("dim") = Dimension(1, nItems);
  std::cout << minIndex;
  for ( unsigned long i=0; i<nItems; i++ ) {
    v[i]=b[minIndex][i];
    std::cout << " " << b[minIndex][i];
  }
  //std::cout << std::endl;
  // std::cout << minDB << std::endl;



  
  if ( printMatrix ) {
    char buffer[500];
    for ( unsigned long i=0; i<nItems; i++ ) {
      for ( unsigned long j=0; j<i; j++ ) {
        sprintf(buffer,"%4.2f ",pp[i][j]);
        std::cerr << buffer;
      }
      std::cerr << "1.00" << std::endl;
    }
  }
  
  return v;
}


// You can include R code blocks in C++ files processed with sourceCpp
// (useful for testing and development). The R code will be automatically 
// run after the compilation.
//

/*** R

*/
