#include "Rcpp.h"

#include "nloptrAPI.h"
//#include "nloptrAPI.h"
// headers
#include <numeric>
#include <iostream>
#include <string>
#include <limits>
#include <time.h>

#include <cmath>
#include <vector>
//#include <nlopt.hpp>
#include <algorithm>
#include <utility>
#include "omp.h"
#include <math.h>
#include <iomanip>

#include <stdlib.h>
#include <stdio.h>

#include<fstream>
#include<time.h>
#include "boostfunc.h"
// headers from the boost library
//#include <boost/math/distributions/normal.hpp>
//#include <boost/math/distributions/students_t.hpp>
//#include <boost/math/special_functions/detail/t_distribution_inv.hpp>

#include <boost/math/distributions/exponential.hpp>
#include <boost/math/tools/roots.hpp>
#include <boost/random.hpp>
#include <boost/math/distributions.hpp>
#include <boost/random/mersenne_twister.hpp>
#include <boost/random/variate_generator.hpp>
#include <boost/math/special_functions/trigamma.hpp>
// headers from the boost library
//#include <boost/math/distributions/normal.hpp>
//#include <boost/math/distributions/students_t.hpp>
//#include <boost/math/special_functions/detail/t_distribution_inv.hpp>
using namespace Rcpp;
using namespace std;
#define _USE_MATH_DEFINES
#ifndef DBL_MAX
#define DBL_MAX 1.79769e+308
#endif

#define LowerBoundUnitInterval  1e-10
#define UpperBoundUnitInterval  1-1e-10
#define lambda    1e-04
// #define HUGE_VAL 

static int fcount = 0, ccount = 0;

// typedef struct {
//   int family;
//   std::vector<double>  U;
//   std::vector<double>  V;
//   unsigned int n;
// } my_data;
typedef struct {
  int family;
  double *U;
  double *V ;
  unsigned int n;
} my_data;

// extern "C"{
//     void mvtdst_(int *N,int *NU,double *LOWER,double *UPPER,int *INFIN,double *CORREL,double *DELTA,int *MAXPTS,double *ABSEPS,double *RELEPS,double *ERROR,double *VALUE,int *INFORM );
// }

// extern"C"
// {
//    extern void mvtdst_(int * N, int * df, double lower [],double upper [], int infin [],double correl [],double delta [],int * maxpts,double * abseps, double * releps, double * error, double * value, int * inform);

// }

extern"C" {


extern void mvtdst_(int* n,
                    int* nu,
                    double* lower,
                    double* upper,
                    int* infin,
                    double* correl,
                    double* delta,
                    int* maxpts,
                    double* abseps,
                    double* releps,
                    double* error,
                    double* value,
                    int* inform);
}

// extern"C" {


// extern void mvtdst_(int* n,
//                     int* nu,
//                     double* lower,
//                     double* upper,
//                     int* infin,
//                     double* correl,
//                     double* delta,
//                     int* maxpts,
//                     double* abseps,
//                     double* releps,
//                     double* error,
//                     double* value,
//                     int* inform); }

inline double CheckBounds(double u)
{
  return max(std::min(u,UpperBoundUnitInterval),LowerBoundUnitInterval);
}


double PairCopulaNegLL(int family, const double* theta, double* U, double* V, unsigned int n)
{
  unsigned int i;
  double CLL=0;
  
  switch(family){
    case 7:
    {
      //Clayton
      if (*theta == 0)
      {
        CLL = 0;
        //printf("theta=0 \n");
      }
        else
      {
        double h1,h2,h3,h9,h12,h14,h15,UU,VV;
        //double h1,h2,h3,h4,h5,h6,h7,h8,h9,h10,h11,h12,h13,h14,h15,UU,VV;
        // printf("theta= %f \n",theta[0]);
        h1 = (1+2* *theta)/ *theta;
        h2 = 1+ theta[0];
        h3 = -*theta;
      
        for (i=0;i<n;i++)
        {
          UU = CheckBounds(U[i]);
          VV = CheckBounds(V[i]);
        
          h9 = pow(UU,h3)+pow(VV,h3)-1;
          h12 = log(h9);
          h14 = log(UU);
          h15 = log(VV);
        
          CLL += h2*(h14+h15)+h1*h12;
        }
        CLL -= log(h2)*n;
      }
      break;
    }
    case 9:
    {
            // Frank
            if (*theta == 0)
            {
                CLL = 0;
            }
            else
            {
                double h1,h2,h3,h4,UU,VV;
                
                h1 = -*theta;
                h2 = expm1(h1);
                h3 = h1*h2;
                
                for (i=0;i<n;i++)
                {
                    UU = CheckBounds(U[i]);
                    VV = CheckBounds(V[i]);
                    h4 = expm1(h1*UU)*expm1(h1*VV);
                    
                    CLL -= log(h3*exp(h1*(UU+VV))/pow(h2+h4,2));
                }
            }
            break;
        }
    case 10:
    {
      // Gaussian
      double x,y,rho2,h1,h2,h3,UU,VV;
      
      rho2 =pow(theta[0],2);
      h1 = 1-rho2;
      h2 = rho2/(2*h1);
      h3 = theta[0] / h1;
      
      
      boost::math::normal dist(0,1);
      
      for (i=0;i<n;i++)
      {
 
          UU = CheckBounds(U[i]);
          VV = CheckBounds(V[i]);

          x = boost::math::quantile(dist, UU);
          y = boost::math::quantile(dist, VV);
        
        //x = gsl_cdf_ugaussian_Pinv(UU);
        //y = gsl_cdf_ugaussian_Pinv(VV);
        
          CLL -= h3*x*y-h2*(pow(x,2)+pow(y,2));
         
      }
      CLL += n/2*log(h1);
      break;
    }
      case 11:
        {
            // Gumbel
            double h1,h2,h3,h4,h5,h6,h7,UU,VV;
            
            h1 = theta[0]-1;
            h2 = (1-2*theta[0])/ theta[0];
            h3 = 1/ theta[0];
            
            for (i=0;i<n;i++)
            {
                UU = CheckBounds(U[i]);
                VV = CheckBounds(V[i]);
                h4 = -log(UU);
                h5 = -log(VV);
                h6 = pow(h4,theta[0]) + pow(h5,theta[0]);
                h7 = pow(h6,h3);
                
                CLL -= -h7+h4+h5+h1*(log(h4)+log(h5))+h2*log(h6)+log(h1+h7);
            }
            break;
        }
        case 17:
        {
            // Tawn2
            //double h1,h2,h3,h4,h5,hv,h2g,h4g,h5g,h6g,h7g,UU,VV;
            double h1,h2,h3,h4,h5,h2g;
            
            h1 = theta[0]-1;
            h2 = (1-theta[0])/ theta[0];
            h3 = 1/ theta[0];
            h4 = 1-theta[1];
            h5 = -theta[1];
            h2g = (1-2*theta[0])/ theta[0];
            
            //#pragma omp parallel for private(i) shared(CLL)
            //#pragma omp parallel for private(i) reduction(-:CLL)
            for (i=0;i<n;i++)
            {
                double hv,h4g,h5g,h6g,h7g,UU,VV;
                UU = CheckBounds(U[i]);  //rotate
                VV = CheckBounds(V[i]);  //rotate
                hv = pow(VV,theta[1]);
                h4g = -log(hv);
                h5g = -log(UU);
                h6g = pow(h4g,theta[0]) + pow(h5g,theta[0]);
                h7g = pow(h6g,h3);
                
                //#pragma omp atomic
                CLL -= log(h4*pow(VV,h5)*pow(h5g,h1)/UU*(pow(h6g,h2))*exp(-pow(h6g,h3))+theta[1]*(exp(-h7g)/hv/UU*pow(h4g,h1)*pow(h5g,h1)*pow(h6g,h2g)*(h1+h7g)));
            }
            break;
        }
  
  }
  
  return CLL;
}

// void LoadDefaultBounds(std::vector<double>  bounds)
// { 
//   int i=0;
//   // Indep
//   int j=0;
//   bounds[j*6] = NAN; // lb1
//   bounds[j*6+1] = NAN; // ub1
//   bounds[j*6+2] = NAN; // lb2
//   bounds[j*6+3] = NAN; // ub2
//   bounds[j*6+4] = NAN; // lb3
//   bounds[j*6+5] = NAN; // ub3
  
 
//   // Clayton
//   j=7;
//   bounds[j*6] = 0; // lb1
//   bounds[j*6+1] = HUGE_VAL; // ub1
//   for (i=2;i<6;i++)
//   {
//     bounds[j*6+i] = NAN;
//   }
 
//   // Gaussian
//   j=10;
//   bounds[j*6] = -0.999; // lb1
//   bounds[j*6+1] = 0.999; // ub1
//   for (i=2;i<6;i++)
//   {
//     bounds[j*6+i] = NAN;
//   }
 
 
  
 
  
//   return;
// }


double ObjectiveFunction( unsigned  n, const double *x,   double *grad, void *data)
{
  my_data *data_for_func = (my_data *) data;
  // int family =data_for_func->family;
  // std::vector<double> U=data_for_func->U;
  // std::vector<double> V=data_for_func->V;
  //  n = data_for_func->n;
   // int family;
   // std::vector<double>  U;
   // std::vector<double>  V;
   
  //NumericVector theta = wrap(x);
  double CLL = PairCopulaNegLL(data_for_func->family,x, data_for_func->U, data_for_func->V,data_for_func-> n);
  return CLL;
  // if (grad) {
  //   grad[0] = 0.0;
  //   grad[1] = 0.5 / std::sqrt(x[1]);
  // }
  // return std::sqrt(x[1]);
  
}





void Town2Fit( int family, double* U, double *V ,unsigned int n, double* theta) 
{ 
   bool verbose = false;
  //LoadDefaultBounds(bounds);
  //nlopt::opt opt(nlopt::LD_MMA, 2);
  nlopt_opt opt;
  
  //nlopt_opt opt;
  // std::vector<double> lb(1);
  // std::vector<double> ub(1);
  // std::vector<double> x(1);

  double lb[2];
  double ub[2];
  double x[2];

  opt = nlopt_create(NLOPT_LN_BOBYQA, 2);
  //opt = nlopt::opt(nlopt::LN_BOBYQA,2);
  switch(family){
      case 17:
    {
        // Tawn2
        lb[0] =  1.001;
        lb[1] = 0.001; // lb2
        nlopt_set_lower_bounds(opt,lb);
        ub[0] = 20;
        ub[1] = 0.999; // ub2
        nlopt_set_upper_bounds(opt,ub);
        x[0] = 5;
        x[1] = 0.5;
      
        break;
    }

  }

  my_data data = {family,U,V,n};
 
  //opt.set_min_objective(ObjectiveFunction,&data);
   nlopt_set_min_objective(opt, ObjectiveFunction, &data);
  // //nlopt_set_min_objective(opt, myfunc, NULL);
  // //opt.set_xtol_rel(1e-5);
   nlopt_set_xtol_rel(opt, 1e-5);

   double minf;
  // // try
  // // {
  // //   //nlopt::result result = opt.optimize(x, minf);
  // //   //nlopt_result result = nlopt_optimize(x, minf);
  // //   nlopt_result result = nlopt_optimize(opt, &(x[0]), &minf);
  // // }
  // // catch(NLOPT_ROUNDOFF_LIMITED) {
  // //   //mexWarnMsgTxt("Halted because roundoff errors limited progress.");
  // // }
  
  if (nlopt_optimize(opt, x, &minf) < 0) {
    if (verbose) Rcpp::Rcout << "nlopt failed!" << std::endl;
  } else {
    if (verbose) {
      Rcpp::Rcout << std::setprecision(5)
                  << "Found minimum at f(" << x[0] << "," << x[1] << ") "
                  << "= " << std::setprecision(8) << minf
                  << " after " << fcount << " function"
                  << " and " << ccount << " constraint evaluations."
                  << std::endl;
    }
  }

  nlopt_destroy(opt);

  theta[0] = x[0];
  theta[1] = x[1];
}

double PairCopulaFit( int family, double* U, double *V ,unsigned int n)   /* input should be in uniform distribution*/
{
 // std::vector<double>  bounds,
 //std::vector<double> theta(1);
 double theta;
  bool verbose = false;
  //LoadDefaultBounds(bounds);
  //nlopt::opt opt(nlopt::LD_MMA, 2);
  nlopt_opt opt;
  
  //nlopt_opt opt;
  // std::vector<double> lb(1);
  // std::vector<double> ub(1);
  // std::vector<double> x(1);

  double lb[1];
  double ub[1];
  double x[1];

  opt = nlopt_create(NLOPT_LN_BOBYQA, 1);
  //opt = nlopt::opt(nlopt::LN_BOBYQA,1);
  switch(family){
    

    case 7:
    {
      //Clayton
     // lb[0] = bounds[(int) family*6];
       lb[0] = {0} ;
      //opt.set_lower_bounds(lb);
     nlopt_set_lower_bounds(opt, lb);
      //ub[0] = bounds[(int) family*6+1];
        ub[0]  =  {HUGE_VAL} ;
      //opt.set_upper_bounds(ub);
      nlopt_set_upper_bounds(opt, ub);
       x[0] = {5};
      break;
    }
     case 9:
            {
                // Frank
                lb[0] = -30;
                nlopt_set_lower_bounds(opt, lb);
                ub[0] = 30;
                nlopt_set_lower_bounds(opt, ub);
                x[0] = 5;
                break;
            }
    case 10:
    {
      
      
      // Gaussian
      //lb[0] = bounds[(int) family*6];
       lb[0]  = {-0.999} ; 
      //opt.set_lower_bounds(lb);
      nlopt_set_lower_bounds(opt, lb);
      //ub[0] = bounds[(int) family*6+1];
       ub[0] = { 0.999 };
      //opt.set_upper_bounds(ub);
      nlopt_set_upper_bounds(opt, ub);
       x[0]= {0};
      break;
    }
    case 11:
    {
      // Gumbel
        lb[0] =  {1};
      nlopt_set_lower_bounds(opt,lb);
        ub[0] = {HUGE_VAL};
      nlopt_set_upper_bounds(opt,ub);
      x[0] = {5};
      break;
    }
   

  }
  my_data data = {family,U,V,n};
 
  //opt.set_min_objective(ObjectiveFunction,&data);
   nlopt_set_min_objective(opt, ObjectiveFunction, &data);
  // //nlopt_set_min_objective(opt, myfunc, NULL);
  // //opt.set_xtol_rel(1e-5);
   nlopt_set_xtol_rel(opt, 1e-5);

   double minf;
  // // try
  // // {
  // //   //nlopt::result result = opt.optimize(x, minf);
  // //   //nlopt_result result = nlopt_optimize(x, minf);
  // //   nlopt_result result = nlopt_optimize(opt, &(x[0]), &minf);
  // // }
  // // catch(NLOPT_ROUNDOFF_LIMITED) {
  // //   //mexWarnMsgTxt("Halted because roundoff errors limited progress.");
  // // }
  
  if (nlopt_optimize(opt, &(x[0]), &minf) < 0) {
    if (verbose) Rcpp::Rcout << "nlopt failed!" << std::endl;
  } else {
    if (verbose) {
      Rcpp::Rcout << std::setprecision(5)
                  << "Found minimum at f(" << x[0] << "," << x[1] << ") "
                  << "= " << std::setprecision(8) << minf
                  << " after " << fcount << " function"
                  << " and " << ccount << " constraint evaluations."
                  << std::endl;
    }
  }

  nlopt_destroy(opt);

 theta = x[0];
 
  return theta;
}




double PairCopulaPDF(int family, double theta1, double U, double V , unsigned int n)
{
    unsigned int i;
    double p;
    switch(family){
         case 10:
        {
            // Gaussian
            double x,y,rho2,h1,h2,h3,UU,VV;
            
            rho2 = pow(theta1,2);
            h1 = 1-rho2;
            h2 = rho2/(2*h1);
            h3 = theta1 /h1;
            
            boost::math::normal dist(0,1);
            
            for (i=0;i<n;i++)
            {
                UU = CheckBounds(U);
                VV = CheckBounds(V);
                //  UU = 1;
                // VV = 0.5;
                
                x = boost::math::quantile(dist, UU);
                y = boost::math::quantile(dist, VV);
                // x=1;
                // y=0.5;
                //x = gsl_cdf_ugaussian_Pinv(UU);
                //y = gsl_cdf_ugaussian_Pinv(VV);

               //p.push_back( exp(h3*x*y-h2*(pow(x,2)+pow(y,2)))/sqrt(h1) );
               p=exp(h3*x*y-h2*(pow(x,2)+pow(y,2)))/sqrt(h1);
               //p=( exp(h3*x*y-h2*(pow(x,2)+pow(y,2)))/sqrt(h1) * denseu *densev ) +p;
                
            }
            break;
        }
 }

  return p;

}



double lambda_sample(double  mean, double var){

   // boost::math::normal dist(mean,var);

   boost::variate_generator<boost::mt19937, boost::normal_distribution<> > generator(boost::mt19937(time(0)), boost::normal_distribution<>(mean,var)); //accept standard deviation
   double r = generator();

    // r=sqrt((r*r));

// boost::variate_generator<boost::mt19937, boost::exponential_distribution<> > generator(boost::mt19937(time(0)), boost::exponential_distribution<>(lambda1));

   //double r = generator();
    return r;


}

double trigammaf(double  x){

   // boost::math::normal dist(mean,var);

   double r = boost::math::trigamma(x);

 
    return r;


}

double MulDisCopulaPDF(int family, double theta1,  double rate_u,double rate_v, double U, double V, unsigned int n, int rotate)
{
    unsigned int i;
    //std::vector<double> p;
    //std::vector<double> vcdf(2);
    //std::vector<double> margdens;


  double p = 0;
  double vcdf[2];
  //double x[1];

    switch(family){
       case 7:
        {
           //Clayton
             if (theta1 == 0)
            {
               p = 1;
            
            }
            else
            {
                double h1,h2,h3,h4,UU,VV,denseu,densev;
                
                boost::math::exponential_distribution<double> ex_u(rate_u);
      
                boost::math::exponential_distribution<double> ex_v(rate_v);
                
                h1 = (1+2*theta1)/ theta1;
                h2 = 1+theta1;
                h3 = -theta1;
                //boost::math::normal dist(0,1);   // temporary, now assume its normal

                for (i=0;i<n;i++)
                {
                    vcdf[0] = boost::math::cdf (ex_u,U);
                    vcdf[1] = boost::math::cdf (ex_v,V);

                   

                    denseu=boost::math::pdf (ex_u,U);
                    densev=boost::math::pdf (ex_v,V);

                     if (rotate==180)
                      {
                            vcdf[0]=1-vcdf[0];
                            vcdf[1]=1-vcdf[1];
                            UU = CheckBounds(vcdf[0]);
                            VV = CheckBounds(vcdf[1]);
                      }
                      else{
                            UU = CheckBounds(vcdf[0]);
                            VV = CheckBounds(vcdf[1]);
                      }
                    // UU = CheckBounds(vcdf[0]);
                    // VV = CheckBounds(vcdf[1]);
                    
                    h4 = pow(UU,h3)+pow(VV,h3)-1;
                    
                    p = (h2*pow(UU,-h2)*pow(VV,-h2)*pow(h4,-h1) * denseu *densev)+p;
                    
                }
            }
            break;
        }
         case 9:
        {
            // Frank
            if (theta1 == 0)
            {
              for (i=0;i<n;i++)
              {
                  p= 1;
              }
            }
            else
            {
              
                double h1,h2,h3,h4,UU,VV,denseu,densev;;
                
                boost::math::exponential_distribution<double> ex_u(rate_u);
      
                 boost::math::exponential_distribution<double> ex_v(rate_v);

                h1 = -theta1;
                h2 = expm1(h1);
                h3 = h1*h2;
                
                for (i=0;i<n;i++)
                {
                    vcdf[0] = boost::math::cdf (ex_u,U);
                    vcdf[1] = boost::math::cdf (ex_v,V);
                    // vcdf[0]=1-vcdf[0];
                    // vcdf[1]=1-vcdf[1];

                    denseu=boost::math::pdf (ex_u,U);
                    densev=boost::math::pdf (ex_v,V);
                    UU = CheckBounds(vcdf[0]);
                    VV = CheckBounds(vcdf[1]);
                    h4 = expm1(h1*UU)*expm1(h1*VV);
                    
                    p=( h3*exp(h1*(UU+VV))/pow(h2+h4,2)* denseu *densev )  + p;
                }
            }
            break;
        }
         case 10:
        {
            // Gaussian
            double x,y,rho2,h1,h2,h3,UU,VV,denseu,densev;
            
            boost::math::exponential_distribution<double> ex_u(rate_u);
      
            boost::math::exponential_distribution<double> ex_v(rate_v);


            rho2 = pow(theta1,2);
            h1 = 1-rho2;
            h2 = rho2/(2*h1);
            h3 = theta1 /h1;
            
            boost::math::normal dist(0,1);
            
            for (i=0;i<n;i++)
            {
                vcdf[0] = boost::math::cdf (ex_u,U);
                vcdf[1] = boost::math::cdf (ex_v,V);
                // vcdf[0]=1-vcdf[0];
                // vcdf[1]=1-vcdf[1];

                denseu=boost::math::pdf (ex_u,U);
                densev=boost::math::pdf (ex_v,V);

                //margdens.push_back(denseu*densev);



                UU = CheckBounds(vcdf[0]);
                VV = CheckBounds(vcdf[1]);
                
                x = boost::math::quantile(dist, UU);
                y = boost::math::quantile(dist, VV);
                
                //x = gsl_cdf_ugaussian_Pinv(UU);
                //y = gsl_cdf_ugaussian_Pinv(VV);

               p=( (exp(h3*x*y-h2*(pow(x,2)+pow(y,2)))/sqrt(h1)) * denseu *densev ) +p;
                
            }

            //p=margdens*p;
            break;
        }
        case 11:
        {
            // Gumbel
            double h1,h2,h3,h4,h5,h6,h7,UU,VV,denseu,densev;

            boost::math::exponential_distribution<double> ex_u(rate_u);
      
            boost::math::exponential_distribution<double> ex_v(rate_v);
            
            h1 = theta1-1;
            h2 = (1-2*theta1)/ theta1;
            h3 = 1/ theta1;

        
            
            for (i=0;i<n;i++)
            {
                vcdf[0] = boost::math::cdf (ex_u,U);
                vcdf[1] = boost::math::cdf (ex_v,V);

                denseu=boost::math::pdf (ex_u,U);
                densev=boost::math::pdf (ex_v,V);
                if (rotate==180)
                {
                      vcdf[0]=1-vcdf[0];
                      vcdf[1]=1-vcdf[1];
                      UU = CheckBounds(vcdf[0]);
                      VV = CheckBounds(vcdf[1]);
                }
                else{
                      UU = CheckBounds(vcdf[0]);
                      VV = CheckBounds(vcdf[1]);
                }
                
                
                
                h4 = -log(UU);
                h5 = -log(VV);
                h6 = pow(h4,theta1) + pow(h5,theta1);
                h7 = pow(h6,h3);
                
                p = (exp(-h7+h4+h5)*pow(h4,h1)*pow(h5,h1)*pow(h6,h2)*(h1+h7)  *denseu*densev) + p;
            }
            break;
      }
      
      
        
 }

  return p;

}


double Town2pdf(int family, double* theta1,  double rate_u,double rate_v,  double shape_u,double shape_v, double U, double V, unsigned int n, int rotate)
{
  unsigned int i;
   

  double p = 0;
  double vcdf[2];
  //double x[1];
  switch(family){
  case 17:
        {
            // Tawn2
            //double h1,h2,h3,h4,h5,hv,h2g,h4g,h5g,h6g,h7g,UU,VV;
            double h1,h2,h3,h4,h5,h2g,denseu,densev;
            // if (shape_u==0)
            // {
              boost::math::exponential_distribution<double> ex_u(rate_u);
      
              boost::math::exponential_distribution<double> ex_v(rate_v);
            // }
            // else{
              
            
       
            h1 = theta1[0]-1;
            h2 = (1-theta1[0])/ theta1[0];
            h3 = 1/ theta1[0];
            h4 = 1-theta1[1];
            h5 = -theta1[1];
            h2g = (1-2*theta1[0])/ theta1[0];
            
            for (i=0;i<n;i++)
            {
                double hv,h4g,h5g,h6g,h7g,UU,VV;
                if (shape_u==0)
                {   
                    if (rotate==0)
                    {
                      vcdf[0] = boost::math::cdf (ex_u,U);
                      vcdf[1] = boost::math::cdf (ex_v,V);
                    }
                    else{
                       vcdf[0] = boost::math::cdf (ex_u,U);
                      vcdf[1] = boost::math::cdf (ex_v,V);
                      vcdf[0] = 1-vcdf[0];
                      vcdf[1] = 1-vcdf[1];
                    }
                    
                    
                
                    denseu=boost::math::pdf (ex_u,U);
                    densev=boost::math::pdf (ex_v,V);
                 }
                 else{
                    boost::math::weibull_distribution<double> wei_u(shape_u,rate_u);
                    boost::math::weibull_distribution<double> wei_v(shape_v,rate_v);
                    vcdf[0] = boost::math::cdf (wei_u,U);
                    vcdf[1] = boost::math::cdf (wei_v,V);
                
                    denseu=boost::math::pdf (wei_u,U);
                    densev=boost::math::pdf (wei_v,V);
                 }

                UU = CheckBounds(vcdf[0]);   //rotate
                VV = CheckBounds(vcdf[1]);    //rotate
                hv = pow(VV,theta1[1]);
                h4g = -log(hv);
                h5g = -log(UU);
                h6g = pow(h4g,theta1[0]) + pow(h5g,theta1[0]);
                h7g = pow(h6g,h3);
                
                p =( h4*pow(VV,h5)*pow(h5g,h1)/UU*(pow(h6g,h2))*exp(-pow(h6g,h3))+theta1[1]*(exp(-h7g)/hv/UU*pow(h4g,h1)*pow(h5g,h1)*pow(h6g,h2g)*(h1+h7g))*denseu*densev )+p;
            }
            break;
        }
  }

        return p;
}

// /*loglikMvdc= log(p)+ log(p)...log(p_n) */
// double MulDisCopulaPDF(int family, double theta1,  double rate_u,double rate_v, double U, double V, unsigned int n)
// {
//     unsigned int i;
//     //std::vector<double> p;
//     //std::vector<double> vcdf(2);
//     //std::vector<double> margdens;


//   double p;
//   double vcdf[2];
//   //double x[1];

//     switch(family){
//        case 7:
//         {
//            //Clayton
//              if (theta1 == 0)
//             {
//                p = 1;
            
//             }
//             else
//             {
//                 double h1,h2,h3,h4,UU,VV;
                
//                 boost::math::exponential_distribution<double> ex_u(rate_u);
      
//                 boost::math::exponential_distribution<double> ex_v(rate_v);
                
//                 h1 = (1+2*theta1)/ theta1;
//                 h2 = 1+theta1;
//                 h3 = -theta1;
//                 //boost::math::normal dist(0,1);   // temporary, now assume its normal

//                 for (i=0;i<n;i++)
//                 {
//                     vcdf[0] = boost::math::cdf (ex_u,U);
//                     vcdf[1] = boost::math::cdf (ex_v,V);

//                     UU = CheckBounds(vcdf[0]);
//                     VV = CheckBounds(vcdf[1]);
                    
//                     h4 = pow(UU,h3)+pow(VV,h3)-1;
                    
//                     p = h2*pow(UU,-h2)*pow(VV,-h2)*pow(h4,-h1);
//                 }
//             }
//             break;
//         }
//          case 10:
//         {
//             // Gaussian
//             double x,y,rho2,h1,h2,h3,UU,VV,denseu,densev;
            
//             boost::math::exponential_distribution<double> ex_u(rate_u);
      
//             boost::math::exponential_distribution<double> ex_v(rate_v);


//             rho2 = pow(theta1,2);
//             h1 = 1-rho2;
//             h2 = rho2/(2*h1);
//             h3 = theta1 /h1;
            
//             boost::math::normal dist(0,1);
            
//             for (i=0;i<n;i++)
//             {
//                 vcdf[0] = boost::math::cdf (ex_u,U);
//                 vcdf[1] = boost::math::cdf (ex_v,V);

//                 denseu=boost::math::pdf (ex_u,U);
//                 densev=boost::math::pdf (ex_v,V);

//                 //margdens.push_back(denseu*densev);



//                 UU = CheckBounds(vcdf[0]);
//                 VV = CheckBounds(vcdf[1]);
                
//                 x = boost::math::quantile(dist, UU);
//                 y = boost::math::quantile(dist, VV);
                
//                 //x = gsl_cdf_ugaussian_Pinv(UU);
//                 //y = gsl_cdf_ugaussian_Pinv(VV);

//                p=( exp(h3*x*y-h2*(pow(x,2)+pow(y,2)))/sqrt(h1) * denseu *densev );
                
//             }

//             //p=margdens*p;
//             break;
//         }
        
//  }

//   return p;

// }

// [[Rcpp::export]]
void PairCopulaCDF(int family, double theta1, double U , double V , unsigned int n)
{
  unsigned int i;
  std::vector<double> p;
  switch(family){
      case 10:
        {
            // Gaussian
            double UU,VV,ABSEPS=0.001,RELEPS=0,ERROR=0,rho,p_tem;
            int N=2,NU=0,MAXPTS=25000,INFORM;
            std::vector<double> ZeroArray(2), UPPER(2);
            std::vector<int> ZeroIntArray{2,2}; 
            
            rho=theta1;
            
            boost::math::normal dist(0,1);   //maybe the reason that the result is different from the R. Use find the default value of the R
            
            for (i=0;i<n;i++)
            {
                UU = CheckBounds(U);
                VV = CheckBounds(V);
                
                UPPER[0] = boost::math::quantile(dist, UU);
                UPPER[1] = boost::math::quantile(dist, VV);
                //mvtdst_(&N,&NU,&ZeroArray[0],&UPPER[0],&ZeroIntArray[0],&rho,&ZeroArray[0],&MAXPTS,&ABSEPS,&RELEPS,&ERROR,&p[i],&INFORM);
                mvtdst_(&N,&NU,&ZeroArray[0],&UPPER[0],&ZeroIntArray[0],&rho,&ZeroArray[0],&MAXPTS,&ABSEPS,&RELEPS,&ERROR,&p_tem,&INFORM);
                p.push_back(p_tem);
            }

            break;
        }
  }
  //return p;
}

double loglik2(int family, double theta, double rate_u ,double rate_v, double shape_u,double shape_v,double U, double V, unsigned int n)
{
   int i;
 
  //rate is the ttf exponential lambda parameter
  //U is not censored, V is censored
  //sum(log(pnorm(qnorm(pexp))))
  //for qnorm(mean=para3*qnorm(pexp(rate=1)),std=sqrt(1-para3^2))
  //loglik.c2 <- sum(log(pnorm(qnorm(pexp(dat[c2.indx,2], rate=para[2])), mean=para[3]*qnorm(pexp(dat[c2.indx,1], rate=para[1])), sd=sqrt(1-para[3]^2), lower.tail=F)*dexp(dat[c2.indx,1],rate=para[1])))
  double loglik=0;
  switch (family)
  {

    case 10:
  {

      double mean_1,sd_1,lik_c2,cdf_norm,dexp_u,truecdf;
      double vcdf[2];
      double norm_incdf[2];
      

       boost::math::exponential_distribution<double> ex_u(rate_u);
      //boost::exponential_distribution<> ex_u(rate_u);
      boost::math::exponential_distribution<double> ex_v(rate_v);
    
        
      
      

      for (i=0;i<n;i++)
    {

      if (shape_u==0)
      {
         vcdf[0] = boost::math::cdf (ex_u,U);
        vcdf[1] = boost::math::cdf (ex_v,V);
      }
      else{
         boost::math::weibull_distribution<double> wei_u(shape_u,rate_u);
         boost::math::weibull_distribution<double> wei_v(shape_v,rate_v);
   
        vcdf[0] = boost::math::cdf (wei_u,U);
        vcdf[1] = boost::math::cdf (wei_v,V);
      }
      
      //first obtain the cdf of exponential distribution
      

      //  vcdf[0]=1-vcdf[0];
      //  vcdf[1]=1-vcdf[1];

      //vcdf_os=ecdf(UU,n);
      //vcdf_ttf=ecdf(VV,n);
       vcdf[0]= CheckBounds(vcdf[0]);  
       vcdf[1] = CheckBounds(vcdf[1]);   

      // //default use normal mean=0, sd=1
      boost::math::normal dist_pn(0,1);
      norm_incdf[0] = boost::math::quantile (dist_pn,vcdf[0]);
      
      // // second step inverse normal cdf ;
      norm_incdf[1] = boost::math::quantile (dist_pn,vcdf[1]);
    

  //   // mean and sd of  normal cdf of U 
      mean_1=theta*norm_incdf[0];
      sd_1=sqrt(1-pow(theta,2));

  //   //third step compute the joint normal cdf
      boost::math::normal dist_qn(mean_1,sd_1);
      cdf_norm=boost::math::cdf(dist_qn, norm_incdf[1]);


  // because T2>t

      truecdf=1-cdf_norm;
  //   //the exp of pdf of u
    if (shape_u==0)
    {
      dexp_u=boost::math::pdf(ex_u,U);
    }
    else{
      boost::math::weibull_distribution<double> wei_u(shape_u,rate_u);
      dexp_u=boost::math::pdf(wei_u,U);
    }
    
      


  //   // transfer inverse cdf to joint normal cdf * pdf of u
       lik_c2=truecdf*dexp_u;

  //  //log-sum -> loglikeloood 
      loglik = loglik+ log(lik_c2) ; 
    }

  }

  break;
  }

  //   if(loglik< -100.00  )
  // {
  //   loglik=0.0;
  // }
  // else if(loglik > 1000.00){
  //   loglik=1.0;
  // }
  return loglik;
}


// [[Rcpp::export]]
double loglik2_ss(int family, double theta, double rate_u ,double rate_v, double U, double V, unsigned int n)
{
   int i;
  //assume U:OS, V:ttf
  //rate is the ttf exponential lambda parameter
  //OS is censored, TTF is not
  //sum(log(pnorm(qnorm(pexp))))
  //for qnorm(mean=para3*qnorm(pexp(rate=1)),std=sqrt(1-para3^2))
  //loglik.c2 <- sum(log(pnorm(qnorm(pexp(dat[c2.indx,2], rate=para[2])), mean=para[3]*qnorm(pexp(dat[c2.indx,1], rate=para[1])), sd=sqrt(1-para[3]^2), lower.tail=F)*dexp(dat[c2.indx,1],rate=para[1])))
  double loglik=0;
  switch (family)
  {

    case 10:
  {

      double mean_os,sd_os,lik_c2,cdf_norm,dexp_u,truecdf;
      double vcdf[2];
      double norm_incdf[2];
      

       boost::math::exponential_distribution<double> ex_u(rate_u);
      //boost::exponential_distribution<> ex_u(rate_u);
      boost::math::exponential_distribution<double> ex_v(rate_v);

      for (i=0;i<n;i++)
    {

    
      //first obtain the cdf of exponential distribution
       vcdf[0] = boost::math::cdf (ex_u,U);
       vcdf[1] = boost::math::cdf (ex_v,V);
      //vcdf_os=ecdf(UU,n);
      //vcdf_ttf=ecdf(VV,n);
       vcdf[0]= CheckBounds(vcdf[0]);   //os
       vcdf[1] = CheckBounds( vcdf[1]);   //ttf

      // //default use normal mean=0, sd=1
      boost::math::normal dist_pn(0,1);
      norm_incdf[0] = boost::math::quantile (dist_pn,vcdf[0]);
      
      // // second step inverse normal cdf ;
      norm_incdf[1] = boost::math::quantile (dist_pn,vcdf[1]);
    

  //   // mean and sd of  normal cdf of our data
      mean_os=theta*norm_incdf[0];
      sd_os=sqrt(1-pow(theta,2));

  //   //third step compute the joint normal cdf
      boost::math::normal dist_qn(mean_os,sd_os);
      cdf_norm=boost::math::cdf(dist_qn, norm_incdf[1]);


  // because T2>t

      truecdf=1-cdf_norm;
  //   //the exp of pdf of u
      dexp_u=boost::math::pdf(ex_u,U);


  //   // transfer inverse cdf to joint normal cdf * pdf of u
       lik_c2=truecdf*dexp_u;

  //  //log-sum -> loglikeloood 
      loglik = loglik+ log(lik_c2) ; 
    }

  }

  break;
  }

  //   if(loglik< -100.00  )
  // {
  //   loglik=0.0;
  // }
  // else if(loglik > 1000.00){
  //   loglik=1.0;
  // }
  return loglik;
}

double loglik3(int family, double theta, double rate_u,double rate_v, double U, double V, unsigned int n){
  //V is not censored, U is censored
  //sum(log(pnorm(qnorm(pexp))))
  //loglik.c3 <- sum(log(pnorm(qnorm(pexp(dat[c3.indx,1], rate=para[1])), mean=para[3]*qnorm(pexp(dat[c3.indx,2], rate=para[2])), sd=sqrt(1-para[3]^2), lower.tail=F)*dexp(dat[c3.indx,2],rate=para[2])))
  unsigned int i;
  double loglik;
  switch (family)
  {
    case 10:
    {
      double mean_os,sd_os,lik_c2,cdf_norm,dexp_u,truecdf;
      
        // std::vector<double> vcdf(2);
        // std::vector<double> norm_incdf(2);

        double vcdf[2];
        double norm_incdf[2];

        boost::math::exponential_distribution<double> ex_u(rate_u);
      //boost::exponential_distribution<> ex_u(rate_u);
        boost::math::exponential_distribution<double> ex_v(rate_v);
        for (i=0;i<n;i++)
      {
        //first obtain the cdf of exponential distribution
        vcdf[0] = boost::math::cdf (ex_u,U);
        vcdf[1] = boost::math::cdf (ex_v,V);

        vcdf[0]= CheckBounds(vcdf[0]);   //os
        vcdf[1] = CheckBounds(vcdf[1]);   //ttf

     // // second step inverse normal cdf ;
      // //default use normal mean=0, sd=1
        boost::math::normal dist_pn(0,1);
        norm_incdf[0] = boost::math::quantile (dist_pn,vcdf[0]);
    
        norm_incdf[1] = boost::math::quantile (dist_pn,vcdf[1]);
      // mean and sd of  normal cdf of not censored data
        mean_os=theta*norm_incdf[1];
        sd_os=sqrt(1-pow(theta,2));

      //third step compute the joint normal cdf
      boost::math::normal dist_qn(mean_os,sd_os);
        cdf_norm=boost::math::cdf(dist_qn, norm_incdf[0]);

      // because T2>t

        truecdf=1-cdf_norm;
  //   //the exp of pdf of u
        dexp_u=boost::math::pdf(ex_v,V);


  //   // transfer inverse cdf to joint normal cdf * pdf of u
       lik_c2=truecdf*dexp_u;

  //  //log-sum -> loglikeloood 
      loglik = loglik+ log(lik_c2) ; 


      }

    }
     break;
  }
    return loglik;
}


double loglik4(int family, double theta, double rate_u,double rate_v, double U, double V, unsigned int n){
  //sum(log(apply(qnorm(cbind(pexp,pexp)))))
  // for qnorm (1,CDF,sigma)
  //sigma=matrix(c(1,para[3]),para[3],1)
  //cdf=pmvnorm

  // sum(log(apply(qnorm(cbind(pexp(dat[c4.indx,1],rate=para[1]), pexp(dat[c4.indx,1],rate=para[2]))),1,CDF,sigma)));
  unsigned int i;
  double loglik;
  //std::vector<double> p; 
  double p; 
  //std::vector<double> norm_incdf(2);
  double norm_incdf[2];
  switch (family)
  {
    case 10:
    { 
          
            
        double UU,VV,ABSEPS=0.001,RELEPS=0,ERROR=0,p_tem,loglik,rho1;
        int N=2,NU=0,MAXPTS=25000,INFORM;
        //std::vector<double> vcdf(2), ZeroArray(2),UPPER(2);  //lower bound and upper bound
        double vcdf[2];
        double ZeroArray[2];
        double UPPER[2];
        int OneIntArray[]={1,1};
        int ZeroIntArray[]={0,0}; 
        //std::vector<int> OneIntArray{1,1};
        //std::vector<int> OneIntArray(2) = {[0 ... 1]=1};

        double rho[2][2]={
          {1.0,theta},
          {theta,1.0}
        };

        rho1=theta;
            

        boost::math::exponential_distribution<double> ex_u(rate_u);
        boost::math::exponential_distribution<double> ex_v(rate_v);

        UPPER[0] = std::numeric_limits<double>::infinity();
        UPPER[1] = std::numeric_limits<double>::infinity();

        for (i=0;i<n;i++)
        {
            //first obtain the cdf of exponential distribution
            vcdf[0] = boost::math::cdf (ex_u,U);
            vcdf[1] = boost::math::cdf (ex_v,U);  //it is U with ex_v
            // printf("vcdf[0] %f vcdf[1] %f",vcdf[0],vcdf[1]);
            vcdf[0]= CheckBounds(vcdf[0]);   //ttf
            vcdf[1] = CheckBounds(vcdf[1]);   //os
            // printf("vcdf[0] %f vcdf[1] %f",vcdf[0],vcdf[1]);

            boost::math::normal dist_pn1(0,1);
            norm_incdf[0] = boost::math::quantile (dist_pn1,vcdf[0]);
            norm_incdf[1] = boost::math::quantile (dist_pn1,vcdf[1]);
            //  printf("norm_incdf[0] %f norm_incdf[0] %f",norm_incdf[0],norm_incdf[1]);

            // mvtdst_(&N,&NU,norm_incdf,UPPER,OneIntArray,&rho[0][0],ZeroArray,&MAXPTS,&ABSEPS,&RELEPS,&ERROR,&p_tem,&INFORM);
            mvtdst_(&N,&NU,&norm_incdf[0],&UPPER[0],&OneIntArray[0],&rho1,&ZeroArray[0],&MAXPTS,&ABSEPS,&RELEPS,&ERROR,&p_tem,&INFORM);
            p=(log(p_tem));

            
        }
        //  loglik = std::accumulate(p.begin(), p.end(),
        //                         decltype(p)::value_type(0));

        

                        
  }
     break;
  }

  return p;
}


void ecdf(double *dta, unsigned int n, double setlambda, double* vcdf)  //cdf of exp distribution
{
 
    
  for (int i=0;i<n;i++){
    //printf("dta[%d]: %f \n",i,dta[i]);
    if(dta[i]!=0){
        vcdf[i] = 1-exp( -dta[i]*setlambda );
    }
      
      else{
        vcdf[i]=0;
      }
  }
  
  
}

double indi_ecdf(double dta, double setlambda)  //cdf of exp distribution
{
    double vcdf;
  //printf("dta[%d]: %f \n",i,dta[i]);
    if(dta!=0){
        vcdf = 1-exp( -dta*setlambda );
    }     
    else{
        vcdf=0.0;
      }
  return vcdf;
}
double wellbull_cdf(double dta, unsigned int n, double shape, double scale)  //cdf of weibull distribution
{
    double vcdf;
     boost::math::weibull_distribution<double> wei_u(shape,scale);

  //printf("dta[%d]: %f \n",i,dta[i]);
    if(dta!=0){
        
        vcdf= boost::math::cdf (wei_u,dta);
                  
    }     
    else{
        vcdf=0.0;
      }
  return vcdf;
}

// [[Rcpp::export]]
void randomgener( double theta, double l, NumericVector V, NumericVector U, NumericVector p, unsigned int n) {
  

    boost::random::mt19937 rng;                                        
    boost::random::uniform_real_distribution<double> gen(0.0, 1.0);
    for (int i = 0; i < 10; ++i) {
        std::cout << gen(rng) << "\n";
    }
    
    double x,y,rho2,h1,h2,h3,UU,VV;
    unsigned int i;
    
    rho2 = pow(theta,2); //theta^2
    h1 = 1-rho2;
    h2 = rho2/(2*h1);
    h3 = theta /h1;
    
    boost::math::normal dist(0,1);
    
    for (i=0;i<n;i++)
    {
      UU = CheckBounds(U[i]);
      VV = CheckBounds(V[i]);
       
      x = boost::math::quantile(dist, UU);  //inverse cdf functions
      y = boost::math::quantile(dist, VV);
      
      //x = gsl_cdf_ugaussian_Pinv(UU);
      //y = gsl_cdf_ugaussian_Pinv(VV);
      
      p[i] = exp(h3*x*y-h2*(pow(x,2)+pow(y,2)))/sqrt(h1);
    }
  
}

// inline double CheckBounds(double u)
// {
//   return max(min(u,UpperBoundUnitInterval),LowerBoundUnitInterval);
// }




