/* ============================================================= 
   Main of clustering with covariates with two TTE outcomes  
   
   /* =============================================================  */
#include <R.h>
#include <Rinternals.h>
#include "R_ext/Rdynload.h"
#include <Rdefines.h>

#include<stdio.h>
#include<stdlib.h>
#include<math.h>
#include <time.h>

#include "ppmx.h"
#include "bayes.h"
#include "rand.h"
#include "ranlib.h"
#include "nrutil.h"
#include "matrix.h"
#include "vector.h"
#include "rand-nr.h"
#include "mess.h"
#include "interface.h"
#include "predict.h"
#include "string.h"



#include "boostfunc.h"

#define Ndiscard 50          /* number of discarded iterations */
#ifdef INFINITY
#endif


/* ***********************************************************
   all MDP pars
/* *********************************************************** */
struct MDP_PARS mdp;
struct SIM_PAR sim;
struct DTA dta;

inline double CheckBounds(double);
double PairCopulaFit( int ,double*  ,double*  ,unsigned int );
double PairCopulaPDF(int, double , double , double  , unsigned int );
void ecdf(double* ,unsigned int ,double,double* );
void Town2Fit( int , double* , double * ,unsigned int , double* ) ;
double Town2pdf(int , double* ,  double ,double , double , double ,double ,double , unsigned int ,int );
double MulDisCopulaPDF(int , double ,  double ,double , double , double , unsigned int ,int);
double loglik2(int , double , double  ,double ,  double ,double ,double , double , unsigned int );
double loglik3(int , double , double  ,double , double , double , unsigned int );
double loglik4(int , double , double  ,double , double , double , unsigned int );
double lambda_sample(double ,double );
double indi_ecdf(double , double ); 
double wellbull_cdf(double , unsigned int , double , double );
double trigammaf(double);

//void PairCopulaPDF(int family, double theta1, double U, double V , unsigned int n)
int n,p,p0,p1,p2,p3,p4,postMCMC;
int uniquecount;
int seeds, simu;

double *m_aux, *s_aux, *q_aux, /* auxiliary arrays of dim nobs
			   for temporary results */
  *c_aux,*l_aux,*pr_aux;

double g1_lmd,g2_lmd,g1_shape,g2_shape,mh_sigma_1,mh_sigma_2;
char parname[20],muname[20],vname[20],vtname[30],sname[30],membername[30],
lsclu_name[30],B_name[30],mean_name[30],mj1name[30],pij2name[30],aj4name[30],
lambda_name[30], copula_name[30], surva_name[30],survb_name[30],pjname[20];
/* -----------------------------------------------------------
   Gibbs iterations
/* ----------------------------------------------------------- */
int n_iter,             /* max iterations */
  iter,                 /* current iter number */
  n_discard,            /* discard the first n_discard draws */
  n_reinitialize,         /* reinitialize configurations */
  n_predupdate,
  n_pi;                 /* every n_pi update expectations etc. */

int n_printallpars;     /* intervals to print all pars if 
			   verbose > 2 */
int m_prior, B_prior, S_prior; 
int n_class0, *member0; /* initial config */

/* -----------------------------------------------------------
   various output files
/* ----------------------------------------------------------- */
FILE *parFile, *muFile, *VFile,*VtFile, *SFile, *meanFile, *BFile, *memberFile,*survfile_a,*survfile_b,
  *lambda_file,*copula_file,
  *lsclu_member,
  *ifile,
  *mj1file, *pij2file, *aj4file;

/* -----------------------------------------------------------
   debugging
/* ----------------------------------------------------------- */
int dbg=0;

/* ============================================================= 
   main
/* ============================================================= */ 
void dbtteppmx(SEXP lst)
{ 
  
  init(lst); 
  init_output();
  pred_init(mdp,dta,seeds,simu);
  init_config();
  gibbs(); 
  finish();
}				  

/* ============================================================= 
   functions called from main
/* ============================================================= */ 



/* ***********************************************************
   init
  (1)init, reads in data, initial par values 
   (2)read the paras obtained from stage 1
/* ***********************************************************
   reads in data, initial par values */

void  init(SEXP lst)
{
  int i, j;
  double r, B_scale, y, cy, d, d2,R1, A1, y2, survrate_1,survrate_2;
  
  char line[250];
  double tempet[250];
  double temp;
  int init_count = 0;

    // basic list
    int l = length(lst);
     printf("l:%d\n",l);
    double **target = malloc(sizeof(double *)*l);
    for (i=0;i<l-1;i++) {

     target[i] = REAL(VECTOR_ELT(lst,i));
     tempet[i]=target[i][0];
   }
 

  
  
  printf("tempet[10]:%f\n",tempet[10]);
  printf("target[29][2]:%f\n",target[29][3]);

  dta.n_obs = (int)tempet[init_count];
  n = dta.n_obs;
  printf("n: %d\n",n);

  
   postMCMC = (int)tempet[1];
 printf("postMCMC: %d\n",postMCMC);

  
   p = (int)tempet[2];
   printf("p: %d\n",p);

  
   p0 =(int)tempet[3];
   printf("p0: %d\n",p0);
   dta.p = p;
   dta.p0 = p0; 
   dta.n_obs=n;

 /* vector initialization after getting the numbers*/
  mdp.V = darray_3(0,n);


  if (p0>1){
    
    mdp.Vt = darray_3(0,n);
     mdp.Vj = darray_3(0,n);
     mdp.V_cd_inv = darray_3(0,n);
     mdp.Vt_cd_inv = darray_3(0,n);
     
   for(j=0;j<=n;j++){             /* don't forget j=n for new */
     
      mdp.V[j] = dmatrix(0,p0-1,0,p0-1);
      mdp.Vj[j] = dmatrix(0,p0-1,0,p0-1);
      mdp.V_cd_inv[j] = dmatrix(0,p0-1,0,p0-1);
      mdp.Vt[j] = dmatrix(0,p0-1,0,p0-1);
      mdp.Vt_cd_inv[j] = dmatrix(0,p0-1,0,p0-1);
      //mdp.clustered_Y[j]=dmatrix(0,n,0,p0-1);
   }
    mdp.mu = dmatrix(0,n,0,p0-1);
    mdp.mj = dmatrix(0,n,0,p0-1);
    mdp.mean = dvector(0,p0-1);

    mdp.S = dmatrix(0,p0-1,0,p0-1);
    mdp.S_cd_inv = dmatrix(0,p0-1,0,p0-1);
    mdp.S_inv = dmatrix(0,p0-1,0,p0-1);
    mdp.R_inv = dmatrix(0,p0-1,0,p0-1);
    mdp.B = dmatrix(0,p0-1,0,p0-1);
    mdp.B_inv = dmatrix(0,p0-1,0,p0-1);
    mdp.B_cd_inv = dmatrix(0,p0-1,0,p0-1);
    mdp.C = dmatrix(0,p0-1,0,p0-1);


   


    mdp.aa = dvector(0,p0-1);
    mdp.A_inv = dmatrix(0,p0-1,0,p0-1);
  } else { // p0=1
    mdp.mu1 = dvector(0,n);
    mdp.V1 = dvector(0,n);
    mdp.Vt1 = dvector(0,n);
    mdp.mj1 = dvector(0,n);
    mdp.Vj1 = dvector(0,n);
  }
  
   mdp.cens = (int)tempet[4];
   printf("cens: %d\n",mdp.cens);
   p1 = (int)tempet[5];
   printf("p1: %d\n",p1);
   p2 = (int)tempet[6];
   printf("p2: %d\n",p2);

  //  dta.q2 = ivector(0,p2);
  //  for(i=0;i<p2;i++){
  //   dta.q2[i] = (int)tempet[7];
  //   printf("dta.q2:%d,",dta.q2[i]);
  //  }

   dta.q2 = ivector(0,p2);
   for(i=0;i<p2;i++){
    dta.q2[i] = target[7][i] ;
    printf("dta.q2:%d,",dta.q2[i]);
   }
  
   
  //  p3 = (int)tempet[7];
  //  printf("p3: %d\n",p3);
   p4 = (int)tempet[8];
   printf("p4: %d\n",p4);
   sim.dahl = (int)tempet[9];
   printf("sim.dahl: %d\n",sim.dahl);
   dta.p1=p1;
  dta.p2=p2;
  dta.p3=p3;
  dta.p4=p4;
  dta.mx_q2=i_max(dta.q2,&i,dta.p2);
  /* vector initialization after getting the numbers*/
  sim.V1=   dvector(0,p1);
  sim.mean1=dvector(0,p1);
  sim.B1=   dvector(0,p1);
  sim.mj1=  dmatrix(0,n-1,0,p1);
  sim.sj1=  dmatrix(0,n-1,0,p1);
  sim.pi2=  dmatrix(0,p2,0,dta.mx_q2);  // prior Dir par's
  sim.pij2= darray_3(0, n);
  sim.aj4 = dmatrix(0,n-1,0,p4);
  sim.bj4 = dmatrix(0,n-1,0,p4);
  sim.a4 = dvector(0,p4);
  sim.b4 = dvector(0,p4);
  sim.alpha1=dvector(0,p1);
  sim.alpha2=dvector(0,p2);
  sim.alpha4=dvector(0,p4);
  
  

 
 /* for list sim.pi2 */
  SEXP elmt = VECTOR_ELT(lst,l-1);
  for(j=0;j<p2;j++){
    double *temp_pi2 = REAL(VECTOR_ELT(elmt, j));
    for(i=0;i<2;i++)
    {
        sim.pi2[j][i]=temp_pi2[i];
        printf("sim.pi2[j][i]:%f",sim.pi2[j][i]);
    }
  }

  init_count = 10;
  if (p1>0){
    
    for(i=0;i<p1;i++)
    {
      sim.V1[i]= target[init_count][i];
     
      sim.mean1[i]=target[init_count+1][i];
      
      sim.B1[i]=target[init_count+2][i];
      
      sim.alpha1[i]=target[init_count+3][i];
   

      printf("sim.V1: %f\n",sim.V1[i]);
      printf("sim.mean1[i]: %f\n",sim.mean1[i]);
      printf("sim.B1[i]: %f\n",sim.B1[i]);
      printf("sim.alpha1[i]: %f\n",sim.alpha1[i]);
    }
    init_count =init_count +4;
  }
  init_count=14;

   if (p2>0)
   {
        for(i=0;i<p2;i++){
        sim.alpha2[i]=1;  
      }
    }
  if (p4>0){
     for(i=0;i<p4;i++){
        sim.a4[i]=target[init_count][i]; 
        sim.b4[i]=target[init_count+1][i]; 
        sim.alpha4[i]=target[init_count+2][i]; 
        printf("sim.a4[i]: %f\n",sim.a4[i]);
        printf("sim.alpha4[i]: %f\n",sim.alpha4[i]);
      }
      init_count=init_count+3;

   }
  init_count  = 17;
  n_iter=(int)tempet[init_count]; 
  printf("n_iter: %d\n",n_iter);
  m_prior=(int)tempet[init_count+1];
  B_prior=(int)tempet[init_count+2];
  S_prior=(int)tempet[init_count+3];
  n_discard=(int)tempet[init_count+4];
  printf("n_discard: %d\n",n_discard);
  n_reinitialize=(int)tempet[init_count+5];
  printf("n_reinitialize: %d\n",n_reinitialize);
  n_pi=(int)tempet[init_count+6];
  n_predupdate=(int)tempet[init_count+7];
  n_printallpars=(int)tempet[init_count+8];
  mdp.verbose=(int)tempet[init_count+9];
  printf("mdp.verbose: %d\n",mdp.verbose);
  mdp.py=(int)tempet[init_count+10];
  mdp.s=(int)tempet[init_count+11]; 
  printf("mdp.s: %d\n",mdp.s);

  init_count=init_count+12;
 
  
   if (p0>1){
    int loopcount=0;
    for(i=0;i<p0;i++){
      for(j=0;j<p0;j++)
      {
        mdp.S[i][j]=target[init_count][loopcount];
        loopcount +=1;
        printf("mdp.S[i][j]: %f\n",mdp.S[i][j]);
      }
      
    }
    
    /* read and invert S */
    d_invert(p0,mdp.S,mdp.S_inv);
    d_chol_decomp(p0,mdp.S_inv,mdp.S_cd_inv);

    mdp.q = (int)tempet[init_count+1];  //30
    printf("mdp.q: %d\n",mdp.q );

   

    loopcount=0;
    for(i=0;i<p0;i++){
      for(j=0;j<p0;j++)
      {
        mdp.R_inv[i][j]=target[init_count+2][loopcount];
        mdp.A_inv[i][j]=target[init_count+7][loopcount];
        loopcount +=1;
        printf("mdp.R_inv[i][j]: %f\n",mdp.R_inv[i][j]);
        printf("mdp.A_inv[i][j]: %f\n",mdp.A_inv[i][j]);   
        //cautious, 0.000035 .= 0.00004
      }
    }

  
 
   
  /* read and invert B */
   B_scale=tempet[init_count+3];
   printf("B_scale: %f\n",B_scale );

   rA(B_scale,mdp.S,mdp.B,p0,p0);   // B = B_scale*S
   d_invert(p0,mdp.B,mdp.B_inv);
   d_chol_decomp(p0,mdp.B_inv,mdp.B_cd_inv);

  mdp.c=(int)tempet[init_count+4]; //initialize?
  printf("mdp.c: %d\n",mdp.c );

  A_zero(mdp.C,p0);    // initialize
  d_invert(p0,mdp.R_inv,mdp.C);
  rA(B_scale,mdp.C,mdp.C,p0,p0);

  for(i=0;i<p0;i++){
     mdp.mean[i]=target[init_count+5][i];
     mdp.aa[i]=target[init_count+6][i];
     printf("mdp.mean[i]: %f\n",mdp.mean[i]);
     printf("mdp.aa[i]: %f\n",mdp.aa[i]);
  }

  init_count=init_count+8;
  

  
   }
   else{
    mdp.S1=tempet[init_count]; //initialize?
    printf("mdp.S1: %f\n",mdp.S1 );
     mdp.q = (int)tempet[init_count+1];  //30
      printf("mdp.q: %d\n",mdp.q );
      R1=tempet[init_count+2];
      mdp.R1_inv = 1.0/R1;
      B_scale=tempet[init_count+3];
      mdp.B1 = B_scale*mdp.S1;
      mdp.c=(int)tempet[init_count+4];
      printf("mdp.c: %d\n",mdp.c );
      mdp.C1 = B_scale*1.0/mdp.R1_inv;
      mdp.mean1=tempet[init_count+5];
      printf("mdp.mean1: %f\n",mdp.mean1 );
      mdp.aa1=tempet[init_count+6];
      printf("mdp.aa1: %f\n",mdp.aa1 );
      A1=tempet[init_count+7];
       printf("A1: %f\n",A1 );
      mdp.A1_inv = 1.0/A1;


      init_count=init_count+8;
   }

  mdp.alpha=tempet[init_count];
  printf("mdp.alpha: %f\n",mdp.alpha);
  mdp.a0=tempet[init_count+1];
  printf("mdp.a0: %f\n",mdp.a0);
  mdp.b0=tempet[init_count+2];
  printf("mdp.b0: %f\n",mdp.b0);
  

  g1_lmd=tempet[init_count+3];
  g2_lmd=tempet[init_count+4];

  printf("g1_lmd: %f, g2_lmd:%f \n",g1_lmd,g2_lmd);

  g1_shape=tempet[init_count+5];
  g2_shape=tempet[init_count+6];

  printf("g1_shape: %f, g2_shape:%f \n",g1_shape,g2_shape);

  mh_sigma_1=tempet[init_count+7];
  mh_sigma_2=tempet[init_count+8];
  seeds=(int)tempet[init_count+9];
  simu=(int)tempet[init_count+10];
  mdp.tr_p1=(int)tempet[init_count+11];
  mdp.tr_p2=(int)tempet[init_count+12];

  printf("sigma_1: %f, sigma_2:%f seeds=%d, simu=%d,mdp.tr_p1=%d, mdp.tr_p2=%d\n",mh_sigma_1,mh_sigma_2,seeds,simu,mdp.tr_p1,mdp.tr_p2);
   
  free(target);

  

// /* -----------------------------------------------------------
//    read in sample size and dim
// /* ----------------------------------------------------------- */
  
  openIn("init.mdp");
  

/* -----------------------------------------------------------
   allocate memory for pars & data
/* -----------------------------------------------------------  */
  dta.Y = dmatrix(0,n-1,0,p-1);
  dta.CY = dvector(0,n-1); // censoring times (if cens=1)
  dta.delta = ivector(0,n-1); // censoring indicator
  dta.xi= ivector(0,n-1);
  
   
  /* note: count, first & upd allow for one extra class =
     "new class" */
  mdp.count = ivector(0,n);
  mdp.first = ivector(0,n);
  
  mdp.member = ivector(0,n-1);
  mdp.updated = ivector(0,n);
  mdp.prev = ivector(0,n);
  mdp.next = ivector(0,n);
 
  
  mdp.newmem = ivector(0,n);

  member0 = ivector(0,n-1);



  m_aux = dvector(0,n-1);
  s_aux = dvector(0,n-1);
  q_aux = dvector(0,n-1);
  c_aux = dvector(0,n-1);
  l_aux = dvector(0,n-1);
  pr_aux = dvector(0,n-1);
  mdp.theta =dvector(0,n-1);
    for (int i = 0; i < n; i++)
  {
    
      mdp.theta[i]=0;
  
  }

  mdp.hy_alpha=dvector(0,p0-1);
  mdp.hy_beta=dvector(0,p0-1);
  
  mdp.lambda_j=dmatrix(0,n,0,p0-1);
  mdp.tawnpara=dmatrix(0,n,0,p0-1);
  for (int i = 0; i < n; i++)
  {
    
      mdp.lambda_j[i][0]=g1_lmd;
      mdp.lambda_j[i][1]=g2_lmd;
    
    
  }
  

  for (int i = 0; i < p0; i++)
  { 
    mdp.hy_alpha[i]=0.15;
    mdp.hy_beta[i]=0.15;
  }
  


    

// /* -----------------------------------------------------------
//    memory alloc for covariates
// /* ----------------------------------------------------------- */
  
  for(j=0;j<n;j++)             /* don't forget j=n for new */
    sim.pij2[j] = dmatrix(0,p2-1,0,dta.mx_q2);


  

 /* -----------------------------------------------------------
    initial config
 /* ----------------------------------------------------------- */
  scanInt(" k0 ", &n_class0);
 
  if (n_class0 == 1){
    for(i=0;i<n;i++)
      member0[i] = 0;
  }
  else if (n_class0 == n){
    for(i=0;i<n;i++)
      member0[i] = i;
  }
  else if (n_class0 == -2){
    for(i=0;i<n;i++)
      member0[i] = i%2;
    n_class0 = 2;
  }
  else
    scanIntArray(" member0 ", member0, n);

  //adam
  if(p1>0 && postMCMC==1)
  {
    //sim.mj1=  dmatrix(0,n-1,0,p1);
    scanDoubleMatrix(" sim-mj ",sim.mj1, n_class0, p1);
 
    
    scanDoubleMatrix(" sim-sj1 ",sim.sj1, n_class0, p1);
  
    
    scan3DMatrix(" sim-pij ", sim.pij2,n_class0,p2,dta.mx_q2);
    
      if(p4>0)
    {
      scanDoubleMatrix(" sim-aj4 ",sim.aj4, n_class0, p4);
      scanDoubleMatrix(" sim-bj4 ",sim.bj4, n_class0, p4);
    }
  
    if (p0==1)
    {
       scanDoubleArray(" mdp-V ", mdp.V, n_class0);
      scanDoubleArray(" mdp-mu1 ", mdp.mu1,n_class0);
    }
    else{
       scanDoubleArray(" exp-alpha ", mdp.hy_alpha, p0);
       scanDoubleArray(" exp-beta ", mdp.hy_beta, p0);

  

      scanDoubleMatrix(" lambda-j ",mdp.lambda_j, n_class0, p1);
      printf("lambda-j %f mdp.lambda_j %f \n",mdp.lambda_j[0][0],mdp.lambda_j[0][1]);

      scanDoubleArray(" theta ", mdp.theta,n_class0);
      printf("mdp.theta %f,%f,%f \n",mdp.theta[0],mdp.theta[1],mdp.theta[2]);

    }
    


  }
 
  
  closeIn();

// /* -----------------------------------------------------------
//    read in data
// /* ----------------------------------------------------------- */
  
  ifile = openIn("data.mdp");
  if (!mdp.cens){
      scanDoubleMatrix(" Y ",dta.Y, n, p);
            
  }
  else { // 2nd and 3rd column are  time and censoring indicator    //in our data only os cencored case
        if(p0>1)
        {
            for(i=0;i<n;i++){
            fscanf(ifile, " %lg %lg %lg %lg", &y,&y2,&d,&d2);
            if (d-floor(d) != 0) 
              err_msg("init","non-integer value for censoring indicator, line %d",i,0,0);
            dta.Y[i][0]=y; dta.xi[i]=d; dta.delta[i]=d2;     dta.Y[i][1]=y2;      // in my understanding cy=y
            if ( (dta.delta[i]!=0) & (dta.delta[i]!=1))
              err_msg("init","delta[%d]=%d. Need 0 or 1.", i,dta.delta[i],0);   
            scanDoubleArray(" ",&dta.Y[i][2],p-2); // cov's
        
          }
        }
    else{
            for(i=0;i<n;i++){
            // fscanf(ifile, " %lg %lg %lg ", &y,&cy,&d);
            fscanf(ifile, " %lg %lg ", &y,&d);
            if (d-floor(d) != 0) 
              err_msg("init","non-integer value for censoring indicator, line %d",i,0,0);
            dta.Y[i][0]=y; dta.delta[i]=d; dta.CY[i]=y;          // in my understanding cy=y
            if ( (dta.delta[i]!=0) & (dta.delta[i]!=1))
              err_msg("init","delta[%d]=%d. Need 0 or 1.", i,dta.delta[i],0);   
            scanDoubleArray(" ",&dta.Y[i][1],p-1); // cov's
          }
      }
  } // censoring
  
  closeIn();

 
  if (sim.dahl==1)
    dahl_init();
  
  /* let the initial value come from the last MCMC */
  if(postMCMC==1){
    for(i=0;i<n_class0;i++)
      mdp.updated[i]=1;
  }

  

}


/* ***********************************************************
   Obtained clustered TTE function
/* *********************************************************** */
void obtainclusteredY(){
  
  int *temp_count;
  temp_count=ivector(0,n-1);
  for (int i = 0; i < n; i++)
   {
   
    mdp.clustered_Y1[mdp.member[i]][temp_count[mdp.member[i]] ] = dta.Y[i][0];
    mdp.clustered_Y2[mdp.member[i]][temp_count[mdp.member[i]] ]= dta.Y[i][1];
    
    temp_count[mdp.member[i]]+=1;
      
   }



   free_ivector(temp_count,0,n);
  
}

  


/* ***********************************************************
   sample the lambda function
/* *********************************************************** */
void sample_lambda(int l)
{
  

  double *cluedY1,*cluedY2;
  
   double gmbeta1,gmbeta2;
    double sum1=0;
    double sum2=0;
    int sum_cenv1,sum_cenv2,tempsubj,tempcount_c;
  cluedY1=dvector(0,mdp.count[l]-1);
  cluedY2=dvector(0,mdp.count[l]-1);

  for (int j = 0; j < mdp.count[l]; j++)
        {
          if (j==0)
          {
            cluedY1[j]=dta.Y[mdp.first[l]][0];
            cluedY2[j]=dta.Y[mdp.first[l]][1];
            tempsubj=mdp.first[l];
          }
          else if(mdp.next[tempsubj]!=-1){
            tempsubj=mdp.next[tempsubj];
            cluedY1[j]=dta.Y[tempsubj][0];
            cluedY2[j]=dta.Y[tempsubj][1];

          }
          
        }

  
  for (int j = 0; j < mdp.count[l]; j++)
  {
      sum1=sum1+cluedY1[j];
      sum2=sum2+cluedY2[j];
  }
 
  for (int j = 0; j < mdp.count[l]; j++)
      {
          if (j==0)
          {
              sum_cenv1=dta.xi[mdp.first[l]];
              sum_cenv2=dta.delta[mdp.first[l]];
              tempcount_c=mdp.first[l];
          }
          else if(mdp.next[tempcount_c]!=-1){
              tempcount_c=mdp.next[tempcount_c];
              sum_cenv1=sum_cenv1+dta.xi[tempcount_c];
              sum_cenv2=sum_cenv2+dta.delta[tempcount_c];
          }
        
      }
  
  
  
  if (p0>1)
  {
    
      
     gmbeta1= (mdp.hy_beta[0]+sum1);
     gmbeta2= (mdp.hy_beta[1]+sum2);
    
    
    //determine the value of s1 and S11  this one should be cluster-specific
    //first obtain the sampleed value of lambda
   
    
      mdp.lambda_j[l][0] = gamdev_ab((mdp.hy_alpha[0]+sum_cenv1),gmbeta1);
      mdp.lambda_j[l][1] = gamdev_ab((mdp.hy_alpha[1]+sum_cenv2),gmbeta2);
       if(mdp.lambda_j[l][0]<1e-99  || mdp.lambda_j[l][1]<1e-99 ){

          while (mdp.lambda_j[l][0]<1e-99|| mdp.lambda_j[l][1]<1e-99)
          {
            mdp.lambda_j[l][0] = gamdev_ab((mdp.hy_alpha[0]+sum_cenv1),gmbeta1);
            mdp.lambda_j[l][1] = gamdev_ab((mdp.hy_alpha[1]+sum_cenv2),gmbeta2);
  
          }
      }
  
     

    
     
     
     free_dvector(cluedY1,0,mdp.count[l]-1);
      free_dvector(cluedY2,0,mdp.count[l]-1);

   
     
  }
  

}

/* ***********************************************************
   sample the lambda(alpha) function
/* *********************************************************** */
void sample_lamalpha(int l){

    double div,pdf1,pdf2,sigma1,sigma2,u;
    double* propo_alpha;
    double a1,a2,b1,b2;
   double *cluedY1,*cluedY2;

    double sum1=0;
    double sum2=0;
    int sum_cenv1,sum_cenv2,tempsubj,tempcount_c;
   
    a1=0.08;
    a2=0.07;
    b1=0.2;
    b2=0.2;

    cluedY1=dvector(0,mdp.count[l]-1);
    cluedY2=dvector(0,mdp.count[l]-1);
    propo_alpha=dvector(0,p1);
    sigma1=0.1;
    sigma2=0.01;


    

  for (int j = 0; j < mdp.count[l]; j++)
        {
          if (j==0)
          {
            cluedY1[j]=dta.Y[mdp.first[l]][0];
            cluedY2[j]=dta.Y[mdp.first[l]][1];
            tempsubj=mdp.first[l];
          }
          else if(mdp.next[tempsubj]!=-1){
            tempsubj=mdp.next[tempsubj];
            cluedY1[j]=dta.Y[tempsubj][0];
            cluedY2[j]=dta.Y[tempsubj][1];

          }
          
        }

  
  for (int j = 0; j < mdp.count[l]; j++)
  {
      sum1=sum1+cluedY1[j];
      sum2=sum2+cluedY2[j];
  }
 
  for (int j = 0; j < mdp.count[l]; j++)
      {
          if (j==0)
          {
              sum_cenv1=dta.xi[mdp.first[l]];
              sum_cenv2=dta.delta[mdp.first[l]];
              tempcount_c=mdp.first[l];
          }
          else if(mdp.next[tempcount_c]!=-1){
              tempcount_c=mdp.next[tempcount_c];
              sum_cenv1=sum_cenv1+dta.xi[tempcount_c];
              sum_cenv2=sum_cenv2+dta.delta[tempcount_c];
          }
        
      }

    //ttf
      propo_alpha[0]=lambda_sample(mdp.hy_alpha[0],sigma1);
      propo_alpha[1]=lambda_sample(mdp.hy_alpha[1],sigma2);
   
      while(propo_alpha[0]==0   ||  propo_alpha[1]==0  )
      {
      
        propo_alpha[0]=lambda_sample(mdp.hy_alpha[0],sigma1);
        propo_alpha[1]=lambda_sample(mdp.hy_alpha[1],sigma2);
      }
    
   // Gamma flat prior
    pdf1=pow(mdp.lambda_j[l][0], (mdp.hy_alpha[0]+sum_cenv1-1))* pow(mdp.hy_alpha[0],(a1+sum_cenv1-1) )*exp(-mdp.hy_alpha[0]*(b1+sum1) );
    pdf2=pow(mdp.lambda_j[l][0], (propo_alpha[0]+sum_cenv1-1))* pow(propo_alpha[0],(a1+sum_cenv1-1) )*exp(-propo_alpha[0]*(b1+sum1) );
    div=pdf2/pdf1;
    u = runif();
    if (div>u)
    {
      mdp.hy_alpha[0]=propo_alpha[0];

    }
   
 // os

     // Gamma flat prior
    pdf1=pow(mdp.lambda_j[l][1], (mdp.hy_alpha[1]+sum_cenv2-1))* pow(mdp.hy_alpha[1],(a2+sum_cenv2-1))*exp(-mdp.hy_alpha[1]*(b2+sum2) );
    pdf2=pow(mdp.lambda_j[l][1], (propo_alpha[1]+sum_cenv2-1))* pow(propo_alpha[1],(a2+sum_cenv2-1))*exp(-propo_alpha[1]*(b2+sum2) );
    div=pdf2/pdf1;
    u = runif();
    if (div>u)
    {
      mdp.hy_alpha[1]=propo_alpha[1];
     
    }
   
      free_dvector(propo_alpha,0,p1); 
   
       free_dvector(cluedY1,0,mdp.count[l]-1);
      free_dvector(cluedY2,0,mdp.count[l]-1);

}
/* ***********************************************************
   sample the lambda(beta) function
/* *********************************************************** */
void sample_labeta(int l){
    
    double div,pdf1,pdf2,sigma1,sigma2,u;
    double* propo_beta;
    double a1,a2,b1,b2;
    double *cluedY1,*cluedY2;
  
    double sum1=0;
    double sum2=0;
    int sum_cenv1,sum_cenv2,tempsubj,tempcount_c;
   
    a1=0.2;
    a2=0.2;
    b1=0.1;
    b2=0.1;

    sigma1=0.1;
    sigma2=0.01;
    cluedY1=dvector(0,mdp.count[l]-1);
    cluedY2=dvector(0,mdp.count[l]-1);
    propo_beta=dvector(0,p1);
     for (int j = 0; j < mdp.count[l]; j++)
        {
          if (j==0)
          {
            cluedY1[j]=dta.Y[mdp.first[l]][0];
            cluedY2[j]=dta.Y[mdp.first[l]][1];
            tempsubj=mdp.first[l];
          }
          else if(mdp.next[tempsubj]!=-1){
            tempsubj=mdp.next[tempsubj];
            cluedY1[j]=dta.Y[tempsubj][0];
            cluedY2[j]=dta.Y[tempsubj][1];

          }
          
        }

  
  for (int j = 0; j < mdp.count[l]; j++)
  {
      sum1=sum1+cluedY1[j];
      sum2=sum2+cluedY2[j];
  }
 
  for (int j = 0; j < mdp.count[l]; j++)
      {
          if (j==0)
          {
              sum_cenv1=dta.xi[mdp.first[l]];
              sum_cenv2=dta.delta[mdp.first[l]];
              tempcount_c=mdp.first[l];
          }
          else if(mdp.next[tempcount_c]!=-1){
              tempcount_c=mdp.next[tempcount_c];
              sum_cenv1=sum_cenv1+dta.xi[tempcount_c];
              sum_cenv2=sum_cenv2+dta.delta[tempcount_c];
          }
        
      }
    
      propo_beta[0]=lambda_sample(mdp.hy_beta[0],sigma1);
      propo_beta[1]=lambda_sample(mdp.hy_beta[1],sigma2);
     while(propo_beta[0]==0 ||  propo_beta[1]==0  )
      {
        propo_beta[0]=lambda_sample(mdp.hy_beta[0],sigma1);
        propo_beta[1]=lambda_sample(mdp.hy_beta[1],sigma2);

      }
    

    pdf1=exp(-mdp.lambda_j[l][0]*mdp.hy_beta[0])*pow(mdp.hy_beta[0],(a1+sum_cenv1-1))*exp(-mdp.hy_beta[0]*(b1+sum1) );
    pdf2=exp(-mdp.lambda_j[l][0]*propo_beta[0])*pow(propo_beta[0],(a1+sum_cenv1-1))*exp(-propo_beta[0]*(b1+sum1) );

    div=pdf2/pdf1;
    u = runif();
    if (div>u)
    {
      mdp.hy_beta[0]=propo_beta[0];

    }


    pdf1=exp(-mdp.lambda_j[l][1]*mdp.hy_beta[1]) * pow(mdp.hy_beta[1],(a2+sum_cenv2-1))*exp(-mdp.hy_beta[1]*(b2+sum2) );
    pdf2=exp(-mdp.lambda_j[l][1]*propo_beta[1]) * pow(propo_beta[1],(a2+sum_cenv2-1))*exp(-propo_beta[1]*(b2+sum2) );



    div=pdf2/pdf1;
     u = runif();
    if (div>u)
    {
      mdp.hy_beta[1]=propo_beta[1];
    }

     free_dvector(propo_beta,0,p1); 
     free_dvector(cluedY1,0,mdp.count[l]-1);
      free_dvector(cluedY2,0,mdp.count[l]-1);
}
void dahl_init()
{
  int i1,i2,first=1;
  double dij;

  for(i1=0;i1<n;i1++){
    for(i2=0;i2<i1;i2++){
      dij = dahl_dist(dta.Y[i1], dta.Y[i2]);
      if (first==1)
	sim.dstar=dij;
      else if (dij > sim.dstar)
	sim.dstar = dij;
      first = 0;
    }
  }
  sim.dstar = sim.dstar*1.01; /* to avoid dist=0 later.. */
}

double dahl_dist(double *x1, double *x2)
{
  double dij;
  int j;

  dij=0;
  for(j=0;j<p1;j++) //continuous covariates
    dij += sqr(x1[p0+j]-x2[p0+j]);
  for(j=0;j<dta.p2;j++) // categorical covariates
    if (x1[p0+p1+j] != x2[p0+p1+j])
      dij += 10.0; 
  for(j=0;j<dta.p4;j++) // count covariates
    dij += sqr(x1[p0+p1+p2+p3+j]-
	       x2[p0+p1+p2+p3+j]);
  return(dij);
}

double dahl_hil(double *xi, int k)
{ // log \sum (h*-hij) 
  int i;
  double hl, lghl;
  
  if (mdp.count[k]==0)
    lghl=0;
  else{
    hl=0;
    for(i=mdp.first[k];i!=-1;i=mdp.next[i])
      hl += sqr( sqr(sim.dstar - dahl_dist(xi, dta.Y[i]) ) );
    lghl = log(hl);
  }
  return(lghl);
}


/* ***********************************************************
   open output files
/* *********************************************************** */
void init_output()
{
  if (seeds==0)
  {
    parFile = openOut("par.mdp");
    muFile = openOut("mu.mdp");
    lambda_file=openOut("lambda.mdp");
    copula_file=openOut("copula.mdp");
    VFile = openOut("V.mdp");
    VtFile= openOut("Vt.mdp");
    SFile = openOut("S.mdp");
    
    memberFile = openOut("member.mdp");  /* configs */
    lsclu_member=openOut("lsmember.mdp");

    BFile = openOut("B.mdp");
    meanFile = openOut("mean.mdp");
    survfile_a=openOut("surv-a.mdp");
    survfile_b=openOut("surv-b.mdp");
    mj1file = openOut("mj1.mdp");
    pij2file = openOut("pij2.mdp");
    aj4file = openOut("aj4.mdp");
  }
  else{
      sprintf(parname,"par_%d.mdp",seeds);
      sprintf(muname,"mu_%d.mdp",seeds);
      sprintf(vname,"V_%d.mdp",seeds);
      sprintf(vtname,"Vt_%d.mdp",seeds);
      sprintf(sname,"S_%d.mdp",seeds);
      sprintf(membername,"member_%d.mdp",seeds);
      sprintf(lsclu_name,"lsmember_%d.mdp",seeds);
      sprintf(B_name,"B_%d.mdp",seeds);
      sprintf(mean_name,"mean_%d.mdp",seeds);
      sprintf(mj1name,"mj1_%d.mdp",seeds);
      sprintf(pij2name,"pij2_%d.mdp",seeds);
      sprintf(aj4name,"aj4_%d.mdp",seeds);
      
      sprintf(lambda_name,"lambda_%d.mdp",seeds);
      sprintf(copula_name,"copula_%d.mdp",seeds);
      sprintf(surva_name,"surva_%d.mdp",seeds);
      sprintf(survb_name,"survb_%d.mdp",seeds);

      parFile = openOut(&parname);

      
      muFile = openOut(&muname);
      VFile = openOut(&vname);
      VtFile = openOut(&vtname);
      SFile = openOut(&sname);
      memberFile = openOut(&membername);  /* configs */

      lsclu_member=openOut(&lsclu_name);

      BFile = openOut(&B_name);
      meanFile = openOut(&mean_name);

      mj1file = openOut(&mj1name);
      pij2file = openOut(&pij2name);
      aj4file = openOut(&aj4name);

      lambda_file=openOut(lambda_name);
      copula_file=openOut(copula_name);
      survfile_a=openOut(surva_name);
      survfile_b=openOut(survb_name);
  }
  
  
  
  
  
  fclose(mj1file); 
  fclose(pij2file); 
  fclose(aj4file); 

  fclose(muFile); 
  fclose(lambda_file);
  fclose(copula_file);
  fclose(SFile); 
  fclose(meanFile); 
  fclose(survfile_a);
  fclose(survfile_b);
  fclose(VFile);
  fclose(VtFile);
  fclose(BFile);
  fclose(parFile);
  fclose(lsclu_member);
   fclose(memberFile); 

 

}





/* ***********************************************************
   initial configuration
/* *********************************************************** */
void init_config()
{
  int i, k, ct;
  
  /* compute inverse and cd of S */
  if (p0>1){
    d_invert(p0,mdp.S,mdp.S_inv);
    d_chol_decomp(p0,mdp.S_inv,mdp.S_cd_inv);
  }
 
  
  /* create n empty groups */
  mdp.n_class = 0;
  for (k=0;k<n;k++){
    mdp.count[k] = 0;
    mdp.first[k] = -1;
    mdp.updated[k] = 0;
    mdp.newmem[k] = 0;

    sample_V(k);
  }

  // /* put obs's in groups */
  for (i = 0; i < n; i++){
    k = member0[i];
    add_class(i,k,1);
  }
  
  
  // /* sample mu's */
  for(k=0;k<mdp.n_class;k++){  // was k<n
    sample_mu(k);
  }

   check_class();


  
}



/* *************************************************
   reinitialize_config
 ************************************************* */
void reinitialize_config()
{
  int i;

  /* remove old config */
  for (i=0;i<n;i++)
    take_out(i,postMCMC);
  init_config();
}

/* ***********************************************************
   Gibbs Sampler
/* *********************************************************** */
void gibbs()
{
  int time, last_init, k;
  
  last_init = 0;
  for (iter = 0; iter < n_iter; iter++){
    if ( (iter % n_reinitialize == 0) & (iter > 0)){
      reinitialize_config();
      last_init = iter;
    }
    if (mdp.verbose > -1) print_pars(iter);
    if (S_prior) sample_S();
    
     mdp.kmax = mdp.n_class;
        sample_config();

    for(int l=0; l<mdp.n_class; l++){
      sample_lambda(l);
      sample_lamalpha(l);
      sample_labeta(l);
     
     }
    for(k=0; k<mdp.n_class; k++){
      sample_mu(k);
       sample_V(k);
    } 
    
    sample_alpha();  
    if (B_prior) sample_B();
    if (m_prior) sample_m();
    
    
    if (iter-last_init > n_discard){
      update_nclass();

  
    
    if (iter % n_pi == 0 || (iter % n_predupdate == 0) ){
      print_pi();
	    write_pars(iter);
	    write_nclass();
    }
    if (iter % n_predupdate == 0) /* update predictive */
	    pred_update(iter, mdp, dta, sim,postMCMC,seeds, simu);



    
    }
  }
}

/* ***********************************************************
   finish
/* *********************************************************** */
void finish()
{
    
     print_pi();
    write_pars(iter);
     pred_finish(mdp, seeds,simu);
}		   
  
/* ============================================================= 
   Conditional draws
/* ============================================================= */ 
	  
/* ***********************************************************
   sample config
/* ***********************************************************
   does the Gibbs over configurations
   Pr(y[i] in class j | ...) proportional to
   for j=0,..n_class-1:
      count[j]*MV-N(y[i]; mut[j], Vt[j])
      mut[j] and Vt[j] computed in make_mut_Vt
   for j=n_class (i.e. new class): same expression with 
                                   count[n_class] = alpha
*/



void sample_config()
{
  int l, k_new, ind,pos;
  double u, mx, hC, mxh, lgr;   /* prob of pi[ind] = pi*[k] */ 
  int si, j;

  // double** vcdf1=dmatrix(0,n,0,n);
  // double** vcdf2=dmatrix(0,n,0,n);
  /* allocate memory */

  // printf("cluster size:%d",mdp.count[32]);
  for (ind = 0; ind < n; ind++){


    u = runif();
    if (mdp.count[mdp.member[ind]] == 1)
      /* toss coin with prob 1/k */
      if (u > 1.0/(1.0*mdp.n_class)) continue;
    if (mdp.member[ind]==-1)
      err_msg("sample_config","clusterless point %d!",ind,0,0);
    
   
   
      if (postMCMC>=1 && mdp.count[mdp.member[ind]] == 1)
    {
       continue;
    }
    else{
        take_out(ind, postMCMC);
    }
 
   if (postMCMC==0)
   {
    /* compute prob pi[ind] = pi*[k]       */
    for(l=0;l<mdp.n_class;l++){
     
      
      if (mdp.updated[l]==0)
	      setup_mu(l,0);
      l_aux[l] = loglik(ind,l,&m_aux[l],&s_aux[l]);
     
      c_aux[l] = logpr(dta.Y[ind],ind,l);
     
      pr_aux[l] = log(1.0*mdp.count[l]);
       
      q_aux[l] =  pr_aux[l] + c_aux[l] + l_aux[l];
      
    }	
   
    /* Prob of new class */
   
    /* q_aux[n_class = alpha * MV-N(y[i],m,V+tau*B)*/
    
      if (mdp.updated[mdp.n_class]==0)
        setup_mu(mdp.n_class,0);
    
   
    l = mdp.n_class;
    l_aux[l] = loglik(ind,l,&m_aux[l],&s_aux[l]);
    if (isnan(l_aux[l]))
      {
            l_aux[l]=0;
      }
   
   
      
   
    c_aux[l] =  logpr(dta.Y[ind],ind,l);
    
  
     
    pr_aux[l] =log(mdp.alpha/(l+1.0)); /* 0 for dahl */
 
    q_aux[l] =  pr_aux[l] + c_aux[l]+ l_aux[l];
  
    /* draw the index of the new class for ind */
    mx = x_max(q_aux,&l,mdp.n_class+1);  /* standardize probs */  //find the largest likelihood
    for(l=0;l <= mdp.n_class;l++)
      q_aux[l]= exp(q_aux[l]-mx);
    /* draw the index of the new class for ind */
   

    }else{
            if (mdp.count[mdp.n_class-1]==0)
          {
            for(l=0;l<mdp.n_class-1;l++){
            if (mdp.updated[l]==0)
              setup_mu(l,0);
            l_aux[l] = loglik(ind,l,&m_aux[l],&s_aux[l]); // save in aux
                      // arrays for debug
            
            c_aux[l] = logpr(dta.Y[ind],ind,l);
            
            
            
            pr_aux[l] = log(1.0*mdp.count[l]);
            q_aux[l] =  pr_aux[l] + c_aux[l] + l_aux[l];
          }	
        
      

            /* Prob of new class */
            // if (postMCMC<1)
            // {
            /* q_aux[n_class = alpha * MV-N(y[i],m,V+tau*B)*/
            if (mdp.updated[mdp.n_class-1]==0)
              setup_mu(mdp.n_class-1,0);
            l = mdp.n_class-1;
            l_aux[l] =  loglik(ind,l,&m_aux[l],&s_aux[l]);
            c_aux[l] =  logpr(dta.Y[ind],ind,l);
            pr_aux[l] = log(mdp.alpha/(l+1.0)); /* 0 for dahl */
            q_aux[l] =  pr_aux[l] + c_aux[l]+ l_aux[l];

            /* draw the index of the new class for ind */
            mx = x_max(q_aux,&l,mdp.n_class);  /* standardize probs */
            for(l=0;l <= mdp.n_class-1;l++)
              q_aux[l]= exp(q_aux[l]-mx);
                    
      }
      else{
        for(l=0;l<mdp.n_class;l++){
            if (mdp.updated[l]==0)
              setup_mu(l,0);
            l_aux[l] = loglik(ind,l,&m_aux[l],&s_aux[l]); // save in aux
                      // arrays for debug
            // printf("which: %d, l_aux[%d]:%f \n",ind,l, l_aux[l]);
            c_aux[l] = logpr(dta.Y[ind],ind,l);
        
            
 
            // printf("which %d,  c_aux[%d]:%f \n",ind,l, c_aux[l]);
            pr_aux[l] = log(1.0*mdp.count[l]);
            q_aux[l] =  pr_aux[l] + c_aux[l] + l_aux[l];
          }	
           /* draw the index of the new class for ind */
            mx = x_max(q_aux,&l,mdp.n_class);  /* standardize probs */
            for(l=0;l <= mdp.n_class-1;l++)
              q_aux[l]= exp(q_aux[l]-mx);
      }

    }


    if(postMCMC==0){
      multinomial(1,mdp.n_class+1,q_aux,&k_new,ind); 
  
    }
    else{
      multinomial(1,mdp.n_class,q_aux,&k_new,ind);
      /* stage2 applied, be careful about the input of the number of clusters*/
      //multinomial_postMCMC(1,mdp.n_class,q_aux,&k_new);
      //q_aux[l]=0;
    } 
    

    if(p0==1){
        if (mdp.cens==1)
          if (dta.delta[ind]==0){ /* censored */
            dta.Y[ind][0] = norm_trunc_left(m_aux[k_new],s_aux[k_new],dta.CY[ind]);
            if (s_aux[k_new]<0.00001)
                err_msg("sample_config","small sd for ind=%d, k=%d.",ind,k_new,0);
        }
     }
   
    
    
    add_class(ind,k_new,0);

     if (k_new == mdp.n_class){ 
      
      if (k_new > mdp.kmax) mdp.kmax = k_new;
    }
  
  }

 
}

double logpr(double *x, int i, int l){
  /* prior prob for l-th class 
     index i is only used for error messages 
     NOTE: i is meaningless when called from predict!! */
  int j, yj, q;
  double sumpij, aj,bj, lpr,yjd, sd;

  if (sim.dahl==1)
    lpr = dahl_hil(x,l); /* returns 0 for l==k+1 */
  else{
    if (l > mdp.n_class)
      err_msg("logpr","l=%d > nclass=%d.",l,mdp.n_class,0);

    lpr=0;

    if (p1>0)
    {
      /* code */
    
    
      for(j=0;j<dta.p1;j++){  // continous covariates
              sd = sqrt(sim.sj1[l][j]+sim.V1[j]);
              lpr += d_normal_dens(x[p0+j],sim.mj1[l][j],sd)*
        sim.alpha1[j];

      }
     
    }


    for(j=0;j<dta.p2;j++){  // categorical covariates
      q = dta.q2[j];
      sumpij = sim.pij2[l][j][q];
      yjd = x[p0+p1+j];
      if ( yjd-floor(yjd) != 0)
	err_msg("sample_config","y[%d][%d] not integer", 
		i,p0+p1+j,0);
      yj=yjd;
      if ( (yj>=q) | (yj<0)) 
	err_msg("sample_config","y[%d][%d]=%d out of range",
		i,j,yj);
      lpr += ( log(sim.pij2[l][j][yj]) - log(sumpij) )*
	sim.alpha2[j];
    }
   // printf("lpr1,%f  \n",lpr);
    for(j=0;j<dta.p4;j++){ // count covariates
      yjd = x[p0+p1+p2+p3+j];
      if ( yjd-floor(yjd) != 0)
	err_msg("sample_config","y[%d][%d] not integer", i,p0+p1+p2+p3+j,0);
      aj = sim.aj4[l][j];
     // printf("aj4,%f l:%d,j:%d \n",sim.aj4[l][j],l,j);
      bj = sim.bj4[l][j];
      //printf("bj,%f  \n",sim.bj4[l][j]);
      lpr += ( aj*log(bj)-(aj+yjd)*log(bj+1.0)+lgamma(aj+yjd)-lgamma(aj) )* sim.alpha4[j];
      
    }
   
  }
  return(lpr);
}

double logpr_simu(double *x, int i, int l){
  /* prior prob for l-th class 
     index i is only used for error messages 
     NOTE: i is meaningless when called from predict!! */
  int j, yj, q;
  double sumpij, aj,bj, lpr,yjd, sd;

  if (sim.dahl==1)
    lpr = dahl_hil(x,l); /* returns 0 for l==k+1 */
  else{
    if (l > mdp.n_class)
      err_msg("logpr","l=%d > nclass=%d.",l,mdp.n_class,0);

    lpr=0;

    if (p1>0)
    {
      /* code */
    
    
      for(j=0;j<mdp.tr_p1;j++){  // continous covariates
              sd = sqrt(sim.sj1[l][j]+sim.V1[j]);
              lpr += d_normal_dens(x[p0+j],sim.mj1[l][j],sd)*
        sim.alpha1[j];

      }
     
    }


    for(j=0;j<mdp.tr_p2;j++){  // categorical covariates
      q = dta.q2[j];
      sumpij = sim.pij2[l][j][q];
      yjd = x[p0+mdp.tr_p1+j];
      if ( yjd-floor(yjd) != 0)
	err_msg("sample_config","y[%d][%d] not integer", 
		i,p0+mdp.tr_p1+j,0);
      yj=yjd;
      if ( (yj>=q) | (yj<0)) 
	err_msg("sample_config","y[%d][%d]=%d out of range",
		i,j,yj);
      lpr += ( log(sim.pij2[l][j][yj]) - log(sumpij) )*
	sim.alpha2[j];
    }
   // printf("lpr1,%f  \n",lpr);
    for(j=0;j<dta.p4;j++){ // count covariates
      yjd = x[p0+p1+p2+p3+j];
      if ( yjd-floor(yjd) != 0)
	err_msg("sample_config","y[%d][%d] not integer", i,p0+p1+p2+p3+j,0);
      aj = sim.aj4[l][j];
      bj = sim.bj4[l][j];
      lpr += ( aj*log(bj)-(aj+yjd)*log(bj+1.0)+lgamma(aj+yjd)-lgamma(aj) )* sim.alpha4[j];
      
    }
   
  }
  return(lpr);
}

double loglik(int i, int l, double *m, double *s){
  /* compute likelihood for i-th observation with moments (mj,Vj) */
  double lp,F,ttf1,ttf2,lambda1,lambda2,sum1,sum2;
  double lik1=0,lik2=0;
  double * ttfset1, * ttfset2,  *towntheta,*cluedY1,*cluedY2,*weight1,*weight2,*cweight;
  int *censored_index;
  int *class_index;
  int sum_cenv1,sum_cenv2,tempcount_c,count_index, rnum,sum_count;

 /* gibbs sampling */
  // double *lambda_j;
  double alpha1,alpha2,beta1,beta2;
 /*    */

 
  ttfset1=dvector(0,n-1);
  ttfset2=dvector(0,n-1);
  weight1=dvector(0,mdp.n_class-1);
  weight2=dvector(0,mdp.n_class-1);
  cweight=dvector(0,mdp.n_class-1);

  
  towntheta=dvector(0,2);
  censored_index=ivector(0,n-1);
   class_index=ivector(0,mdp.n_class-1);
  // lambda_j=dvector(0,2);
  cluedY1=dvector(0,mdp.count[l]);
  cluedY2=dvector(0,mdp.count[l]);

  
  double log(); 
  int t,j, tempsubj,lg_num_clus;
  int normalc=0;

  lg_num_clus= (int)((dta.n_obs/n_class0)+0.5);
  
  if(lg_num_clus>3 && lg_num_clus<5)
  {
    lg_num_clus=5;
  }
  else if(lg_num_clus>5 && lg_num_clus<10){
    lg_num_clus=10;
  }
  else if(lg_num_clus>=10){
    lg_num_clus=15;
  }
   else if(lg_num_clus<=3){
    lg_num_clus=0;
  }
  
  
  if (l > mdp.n_class)
    err_msg("loglik","l=%d > nclass=%d.",l,mdp.n_class,0);

  
  for (int j = 0; j < mdp.count[l]; j++)
    {
          if (j==0 && mdp.first[l]!=-1)
          {
            cluedY1[j]=dta.Y[mdp.first[l]][0];
            cluedY2[j]=dta.Y[mdp.first[l]][1];
            tempsubj=mdp.first[l];
          }
          else if(mdp.next[tempsubj]!=-1){
            tempsubj=mdp.next[tempsubj];
            cluedY1[j]=dta.Y[tempsubj][0];
            cluedY2[j]=dta.Y[tempsubj][1];

          }
          
      }
    cluedY1[mdp.count[l]]=dta.Y[i][0];        // add the new data into the cluster
    cluedY2[mdp.count[l]]=dta.Y[i][1]; 


    count_index=0;
    sum1=0;
    sum2=0;
    for (int j = 0; j < mdp.n_class; j++)
    {
      // printf("j1:%d, mdp.n_class:%d \n",j, mdp.n_class);
      if (mdp.count[j]>lg_num_clus)
      {
      
        class_index[count_index]=j;
         count_index+=1;
        
      }
      
    }
   
    /* weight calculation */ 
    
     lambda1=0;
     lambda2=0;
   //varaince (1/lambda_j^2)* lambda_j in expnential 
  //weight = 1/var. In exponential var= 1/v^2
  //calculate the sum first to let it sum up with 1
     if (mdp.count[l]<1)
     {
            for (int j = 0; j < count_index; j++)
        {
          sum1+=pow(mdp.lambda_j[class_index[j]][0],2);   
          sum2+=pow(mdp.lambda_j[class_index[j]][1],2);
            
        }
        //weight=v^-1
        for (int j = 0; j < count_index; j++)
        {
          weight1[j]= pow(mdp.lambda_j[class_index[j]][0],2)/sum1;
          weight2[j]= pow(mdp.lambda_j[class_index[j]][1],2)/sum2;
          
          
        }
        for (int j = 0; j < count_index; j++)
        {
          //weighted average posterior
          lambda1+=mdp.lambda_j[class_index[j]][0] * weight1[j];
          lambda2+=mdp.lambda_j[class_index[j]][1] * weight2[j];
      

        }
        mdp.lambda_j[l][0]=lambda1;
        mdp.lambda_j[l][1]=lambda2;
        
      }
     else{
        lambda1=mdp.lambda_j[l][0];
        lambda2=mdp.lambda_j[l][1];
     }
     
  
    
  if (p0>1)
  {
       
        
       for (int j = 0;j < mdp.count[l]+1; j++)
      {
        if (g1_shape==0)
        {

             ttfset1[j]=indi_ecdf( cluedY1[j], lambda1);
             ttfset2[j]=indi_ecdf( cluedY2[j], lambda2);
            
        }
        else{
          ttfset1[j]=wellbull_cdf( cluedY1[j],n,  g1_shape,g1_lmd);
          ttfset2[j]=wellbull_cdf(cluedY2[j],n,  g2_shape,g2_lmd);
        }
        
      
        
        
          
      } 
       
   

  
  
    if (!mdp.cens){
      //  Town2Fit(17,ttfset1,ttfset2,mdp.count[l]+1,towntheta);  
 
       mdp.theta[l]=PairCopulaFit(10,ttfset2,ttfset1,mdp.count[l]+1);
    }
    else{
          if (mdp.count[l]< 1)
          { 
                for (int j = 0; j < count_index; j++)
                {
                  sum_count+= mdp.count[class_index[j]] ;   
                      
                }
     
                for (int j = 0; j < count_index; j++)
                {
                  cweight[j]=mdp.count[class_index[j]] /sum_count;
                
                  
                }
                for (int j = 0; j < count_index; j++)
                {
                  //weighted average posterior
                  mdp.theta[l]+= cweight[j]* mdp.theta[class_index[j]];
                

                }
               
          }
         
       
          
          

        else
        {
          
          mdp.theta[l]=PairCopulaFit(10,ttfset1,ttfset2,mdp.count[l]+1);
         
        
        }

    }
  
  }
  


  if (!mdp.cens){
    if (p0>1){ 
      
               lik1 = MulDisCopulaPDF(10,mdp.theta[l], lambda1, lambda2,dta.Y[i][0],dta.Y[i][1],1,1);
   
              lik1=log(lik1);
              lp=lik1;
              
          
    }
    else{
   
        lp = d_normal_dens(dta.Y[i][0],mdp.mj1[l],sqrt(mdp.Vt1[l]));
     
    }
  } else{

    if (p0>1)
    { 
     
            
      
          if (dta.delta[i]==1 && dta.xi[i]==1)
          {
                          

                    lik1 = MulDisCopulaPDF(10,mdp.theta[l], lambda1, lambda2,dta.Y[i][0],dta.Y[i][1],1,1);
                    lik1=log(lik1);
                
                    lp=lik1;
                // }
                
   
              
          }

         else if(dta.delta[i]==1 && dta.xi[i]==0)
         {
      
              lik2 =loglik2(10,mdp.theta[l],lambda1, lambda2,g2_shape,g1_shape,dta.Y[i][0],dta.Y[i][1],1); 
    
              lp=lik2;
            }
          else if (dta.delta[i]== 0 && dta.xi[i]==1)
          {
            lp =loglik3(10,mdp.theta[l],lambda1, lambda2,dta.Y[i][0],dta.Y[i][1],1);  
            
          }
          else{
               lp =loglik4(10,mdp.theta[l],lambda1, lambda2,dta.Y[i][0],dta.Y[i][1],1); 
               
          }
          
       

         
    }
    else{
        *m = mdp.mj1[l];
      *s = sqrt(mdp.Vt1[l]);
      if (dta.delta[i]==0){/* censored */
       F = cdfnorm(dta.CY[i],*m,*s);
       lp = log(1.0-F);
        } else { /* not */
        lp = d_normal_dens(dta.Y[i][0],*m,*s);
      }

    }
    

  
  }




    free_dvector(ttfset1,0,n); 
    free_dvector(ttfset2,0,n); 
    free_dvector(weight1,0,mdp.n_class-1); 
    free_dvector(weight2,0,mdp.n_class-1); 
    free_dvector(cweight,0,mdp.n_class-1); 
   
    free_ivector(class_index,0,mdp.n_class-1);
    free_dvector(cluedY1,0,n);
    free_dvector(cluedY2,0,n);
  
  return(lp);
}

/* -----------------------------------------------------------
   check class
/* ----------------------------------------------------------- */
/* checks for bogous classes */

void check_class(){
  int i,j,k;

  for(k=0;k<mdp.n_class;k++){
    for(j=0,i=mdp.first[k]; i!=-1; j++, i = mdp.next[i])
      if (j>mdp.count[k])
	printf("\n*** Error: class %d is bogous.\n", k);
  }
}

/* -----------------------------------------------------------
   take_out
/* ----------------------------------------------------------- */
void take_out(int ind, int postMCMC)
{
  int k_old,i,k,dta_pos;
  dta_pos=0;
  k = mdp.n_class-1;

  
 
 
  /* take y[ind] out of it's current class */
  k_old = mdp.member[ind];
 

  mdp.count[k_old] -= 1;

  mdp.updated[k_old] = 0;
  mdp.member[ind] = -1;


  
  if (mdp.prev[ind] == -1)
    mdp.first[k_old] = mdp.next[ind];
  else mdp.next[mdp.prev[ind]] = mdp.next[ind];   //the previous one 's next one becomes the k_old next one (k_old is out)
  mdp.next[ind] = -1;
  mdp.prev[ind] = -1;
  
    /* if class k=k_old is empty, postMCMC applied */
if (postMCMC<1)
{
  
  if (mdp.count[k_old] == 0){
   
  /* relabel class k=n_class-1 as k_old */
    mdp.updated[k_old] = mdp.updated[k];
    mdp.updated[k] = 0;
    mdp.count[k_old] = mdp.count[k];
    mdp.count[k] = 0;
    mdp.first[k_old] = mdp.first[k];  //at this point first k old = mdp first k
    mdp.first[k] = -1;
    mdp.newmem[k_old] = mdp.newmem[k];

    if (p0>1){
      A_swap_B(mdp.V[k_old],mdp.V[k],p0,p0);
      A_swap_B(mdp.Vt[k_old],mdp.Vt[k],p0,p0);
      A_swap_B(mdp.Vj[k_old],mdp.Vj[k],p0,p0);
      A_swap_B(mdp.V_cd_inv[k_old],mdp.V_cd_inv[k],p0,p0);
      A_swap_B(mdp.Vt_cd_inv[k_old],mdp.Vt_cd_inv[k],p0,p0);   
      x_swap_y(mdp.mu[k_old],mdp.mu[k],p0);
      x_swap_y(mdp.mj[k_old],mdp.mj[k],p0);

      x_swap_y(mdp.lambda_j[k_old],mdp.lambda_j[k],p1);
     

      

      


    } else { // probably no need to swap, could just kold <- k
      r_swap_s(&mdp.mu1[k_old],&mdp.mu1[k]);
      r_swap_s(&mdp.V1[k_old],&mdp.V1[k]);
      r_swap_s(&mdp.Vt1[k_old],&mdp.Vt1[k]);
      r_swap_s(&mdp.mj1[k_old],&mdp.mj1[k]);
      r_swap_s(&mdp.Vj1[k_old],&mdp.Vj1[k]);
    }

    x_swap_y(sim.mj1[k_old],sim.mj1[k],p1);
    x_swap_y(sim.sj1[k_old],sim.sj1[k],p1);
    A_swap_B(sim.pij2[k_old],sim.pij2[k],p2,dta.mx_q2);
    x_swap_y(sim.aj4[k_old],sim.aj4[k],p4);
    x_swap_y(sim.bj4[k_old],sim.bj4[k],p4);

    /* update member-references to the relabeled class */
    for(i=mdp.first[k_old];i!=-1;i=mdp.next[i])
      mdp.member[i] = k_old;
    
    /* decrement n-class by one */
    if(postMCMC==0)
    {
      mdp.n_class -= 1;
    }
      check_class();

  }
}

}
/* -----------------------------------------------------------
   add_class
/* -----------------------------------------------------------
   adds obs[ind] to class[k] postMCMC added
*/
void add_class(int ind, int k, int init)
{
  
  mdp.updated[k] = 0;
  mdp.count[k] += 1;

    if (mdp.count[k] == 1){
    mdp.newmem[k] = 1;
    if (postMCMC==0)
    {
      mdp.n_class += 1;
    }
    else{
      if(init==1)
      {
        mdp.n_class += 1;
      }
     
      // }
    }
 
  }
  mdp.member[ind] = k;
  
  mdp.next[ind] = mdp.first[k];
  //printf( "mdp.next[%d]:%d \n",ind,mdp.next[ind]);
  mdp.first[k] = ind;
  //printf( " mdp.first[%d]:%d \n",k, mdp.first[k]);
  if (mdp.count[k] > 1)   
  {
    //printf( "mdp.next[%d]:%d \n",ind,mdp.next[ind]);
    mdp.prev[mdp.next[ind]] = ind;
  }
  mdp.prev[ind] = -1;

  
  
  check_class();

  
}
/* -----------------------------------------------------------
   make_ybar
/* ----------------------------------------------------------- */
void make_ybar(int k, double *ybar)
{
  int i;
  double nk;

  nk = 1.0*mdp.count[k];
  x_zero(ybar,p0); /* initialize ybar=0 */
  for(i=mdp.first[k];i!=-1;i=mdp.next[i]){
    x_plus_y(ybar,dta.Y[i],ybar,p0);
  }
  if (mdp.count[k] != 0) x_div_r(ybar,nk,ybar,p0);
}
/* -----------------------------------------------------------
   make_Sk
/* ----------------------------------------------------------- */
void make_Sk(int k, double **S)
{
  int i,j1,j2;
  double nk, *z;

  /* allocate memory */
  z = dvector(0,p0-1);

  nk = 1.0*mdp.count[k];
  A_zero(S,p0);   //d: p0 x p0
  for(i=mdp.first[k];i!=-1;i=mdp.next[i]){
    x_min_y(dta.Y[i],mdp.mu[k],z,p0);
    A_plus_rxxt(S,1.0,z,S,p0);
  }
  free_dvector(z,0,p0-1);
}

double make_Sk1(int k)
{
  int i,j1,j2;
  double nk, S;

  nk = 1.0*mdp.count[k];
  S = 0;
  for(i=mdp.first[k];i!=-1;i=mdp.next[i])
    S += sqr(dta.Y[i][0]-mdp.mu1[k]);
  return(S);
}





/* *************************************************
   setup_mu
 ************************************************* */
void setup_mu(int k, int draw)
{
  int j;
  double **V_inv, *ybar, nk;
  double **Vj, **Vj_inv, Vj1, ybar1;

  nk = 1.0*mdp.count[k];
  if (p0>1){

    /* allocate memory for the auxilary arrays */
    ybar = dvector(0,p0-1);
    V_inv = dmatrix(0,p0-1,0,p0-1);
    Vj_inv = dmatrix(0,p0-1,0,p0-1);
    Vj = dmatrix(0,p0-1,0,p0-1);

    if (mdp.count[k] == 0){
      
      B_assgn_A(Vj,mdp.B,p0);
      y_assgn_x(mdp.mj[k],mdp.mean,p0);
    }
    else{
      
      /* get pars for conditional posterior p(mu|...) */
      make_ybar(k, ybar);
      d_invert(p0,mdp.V[k], V_inv);  // V_inv= inverse mdp.Vk 
    
      // /* compute posterior mean cov matrix for mu[k] */
      nn_bayes(1.0,mdp.B_inv,mdp.mean, 1.0/nk, V_inv, ybar,Vj, Vj_inv, mdp.mj[k], p0);

    }

    /* keep for update_pred */
    // B_assgn_A(mdp.Vj[k],Vj,dta.p);
      B_assgn_A(mdp.Vj[k],Vj,dta.p0);
      
    // // /* if draw, then sample mu[k] */
    if (draw==1)
      mvnS_rand(p0,mdp.mj[k],Vj,mdp.mu[k]);

    // // /* Vt = (Vj + V[k]) */
    rA_plus_sB(1.0,Vj,1.0,mdp.V[k],mdp.Vt[k],p0);
 
    invcd(p0,mdp.Vt[k],mdp.Vt_cd_inv[k]); 
    /* free memory */
    free_dvector(ybar, 0,p0-1);
    free_dmatrix(V_inv,0,p0-1,0,p0-1);
    free_dmatrix(Vj_inv,0,p0-1,0,p0-1);
    free_dmatrix(Vj,0,p0-1,0,p0-1);

  } else { // p0=1
    // printf("p0 in mu = %d", p0);
    if(mdp.count[k]==0){
      Vj1 = mdp.B1;
      mdp.mj1[k] = mdp.mean1;
    }
    else {
      make_ybar(k, &ybar1);
      /* compute posterior mean cov matrix for mu[k] */
      nn_bayes1(1.0,1.0/mdp.B1,mdp.mean1, 1.0/nk, 1.0/mdp.V1[k],ybar1,&Vj1,&mdp.mj1[k]);
    }
    mdp.Vj1[k]=Vj1;
    mdp.Vt1[k] = Vj1+mdp.V1[k];
    if(draw==1)
      mdp.mu1[k]=mdp.mj1[k]+sqrt(Vj1)*norm_rand();
  }
   // printf(" aj4,%f  \n",sim.aj4[88][0]);
    //printf("p1= %d,",p1);
    /* covariates */
    for(j=0;j<p1;j++)
      setup_mj1(j,k,draw);
    for(j=0;j<p2;j++)
      setup_pij2(j,k,draw);
    for(j=0;j<p4;j++)
      setup_aj4(j,k,draw);
  
   // printf("after aj4,%f  \n",sim.aj4[88][0]);
  
    mdp.updated[k] = 1;
}

/* ***********************************************************
   sample_mu
/* ***********************************************************
   sample mu[k] from N(mu; m(y), T)
   where {m(y),T} = T*(nj*V-inv[k]*ybar[k] + B-inv/tau*m),
                    T-inv = nj*V-inv[k] + B-inv/tau.
*/
void sample_mu(int k)
{

  setup_mu(k,1);
}

/* ***********************************************************
   sample_V
/* *********************************************************** */
/* V[k] from W(1/V[k]; s+n[k], (sS+S[k])^-1),
   where S[k] = sum (y[i]-mu[k])(y[i]-mu[k])'
*/
void sample_V(int k)
{ 
  double **Sk, **S1, **S1_inv_cd,
    **V_cd, **V_inv,
    V11,s1,Vinv1, Sk1, S11;
 int j1,j2;

 if (p0>1){
   /* allocate memory */

   V_cd = dmatrix(0,p0-1,0,p0-1);
   V_inv = dmatrix(0,p0-1,0,p0-1);
   Sk = dmatrix(0,p0-1,0,p0-1);
   S1 = dmatrix(0,p0-1,0,p0-1);
   S1_inv_cd = dmatrix(0,p0-1,0,p0-1);
   A_zero(V_inv,p0);

   /* Sk = sum (y[i]-mu[j])(y[i]-mu[j]) over member[i]=j */
   make_Sk(k,Sk);

  // /* S1 = s*S+Sk */
   rA_plus_sB(mdp.s*1.0, mdp.S, 1.0, Sk, S1, p0);  // note p0
   cdinv(p0,S1,S1_inv_cd);                         // note p0
   wishart(mdp.s+mdp.count[k], p0, S1_inv_cd, V_inv);
   /* nuke out the off-diagonal elements - assume indep of
      obs vector and cov */

    /* compute V, V_cd, V_inv_cd etc. */
   d_chol_decomp(p0,V_inv, mdp.V_cd_inv[k]);
   d_inv_triang(p0,mdp.V_cd_inv[k],V_cd);
   ABt(V_cd,p0,p0,V_cd,p0,p0,mdp.V[k]);


   /* error check */
   if (isnan(mdp.V[k][0][0])){
     error("sample_V", "Vt is NaN.", 1);
   }

   /* allocate memory for the auxilary arrays */
   free_dmatrix(V_cd,0,p0-1,0,p0-1);
   free_dmatrix(V_inv,0,p0-1,0,p0-1);
   free_dmatrix(S1,0,p0-1,0,p0-1);
   free_dmatrix(Sk,0,p0-1,0,p0-1);
   free_dmatrix(S1_inv_cd,0,p0-1,0,p0-1);
 }
  else { //p0=1, univariate
   /* V[k] from G(1/V[k]; (s+n[k])/2, 1/2*(sS+S[k])),
      where S[k] = sum (y[i]-x[i]'mu[k])^2   */
   /* Sk = sum (y[i]-mu[j])(y[i]-mu[j]) over member[i]=j */
  //  printf("this is p0=%d,",p0); //debug
   Sk1 = make_Sk1(k);

   /* S1 = s*S+Sk */
   S11 = 0.5*(mdp.s*mdp.S1+Sk1);
   s1 = 0.5*(mdp.s+mdp.count[k]);
   Vinv1 = gamdev_ab(s1,S11);
   mdp.V1[k] = 1.0/Vinv1;
  
 }
}
    


/* ***********************************************************
   sample S
/* *********************************************************** 
   generates S from W(S; q+k*s, U)
   U = {(R/q)^-1 + s*sum V_inv[k]}^(-1)
*/
void sample_S()
{
  int k,j1,j2;
  double **U_inv, **U_cd, **V_inv;
  double s,r1,R1,Vinv,S1;

  if (p0>1){
    /* allocate memory for aux arrays */
    V_inv = dmatrix(0,p0-1,0,p0-1);
    U_inv = dmatrix(0,p0-1,0,p0-1);
    U_cd = dmatrix(0,p0-1,0,p0-1);
    mdp.S = dmatrix(0,p0-1,0,p0-1);
    mdp.S_cd_inv = dmatrix(0,p0-1,0,p0-1);

    A_zero(mdp.S,p0); /* initialize */

    /* initialize U_inv = (R/q)^-1 = q/R */
    rA(1.0*mdp.q, mdp.R_inv, U_inv, p0, p0); /* 1.0*q is double */ //b= r multiple A in vector.c
    /* note p0! */

    /* loop over all k classes, add up Vbar_inv and mu */
    s = mdp.s*1.0; /* s_double is double ! */
    for(k=0;k<mdp.n_class;k++){
      /* add (s-p0-1)*mdp.V_inv[k] */
      d_invert(p0, mdp.V[k], V_inv);         // note p0
      AplusBr(U_inv, V_inv, s, U_inv, p0);   // 
    }
  
    // /* compute U_cd */
    cdinv(p0,U_inv,U_cd);

    // /* generate S from Wish(q+s*k, U) */
    wishart(mdp.q+mdp.n_class*mdp.s, p0, U_cd, mdp.S);

    // /* nuke out the off-diagonal elements - assume indep of
    //    obs vector and cov */
    invcd(p0,mdp.S,mdp.S_cd_inv);

    // /* free auxilary arrays */
    free_dmatrix(V_inv,0,p0-1,0,p0-1);
    free_dmatrix(U_inv,0,p0-1,0,p0-1);
    free_dmatrix(U_cd,0,p0-1,0,p0-1);
  } else {
    /* prior:  S ~ Ga(q/2, 1/2*q/R), i.e. E(S)=R
       likl:   1/V[k] ~ Ga(s/2, 1/2*sS)
       post:   S|V    ~ Ga[1/2*(q+s*nk), 1/2(q/R + \sum s/V[k])] */
  
    s = 1.0*mdp.s;
    r1 = 0.5*(mdp.q+s*mdp.n_class);
    R1 = 0.5*(mdp.q*mdp.R1_inv);

    /* loop over all k classes, add up Vbar_inv and mu */
    for(k=0;k<mdp.n_class;k++){
      R1 += 0.5*s/mdp.V1[k];
    }
    /* generate S from Wish(q+s*k, U) */
    mdp.S1 = gamdev_ab(r1,R1);
    
  }

  return;
}



/* ***********************************************************
   sample m
/* *********************************************************** 
/* m from p(m|..) = N(m; m(mubar), T)
   m(ybar[k]) = T*(B-inv/tau*k*mubar + A-inv*a)
   T-inv = B-inv/tau*k + A-inv
*/
void sample_m()
{
  double *mubar, mubar1, K;
  int i;


  K = mdp.n_class; /* need double */
  if (p0>1){
    /* allocate memory */
    mubar = dvector(0,p0-1);
  
    /* make mubar = 1/K sum mu[k] */
    x_zero(mubar,p0); /* initialize mubar=0 */
    for(i=0;i<mdp.n_class;i++){
      x_plus_y(mubar,mdp.mu[i],mubar,p0);
    }
    x_div_r(mubar,K,mubar,p0);

    /* compute and sample posterior on m */
    nn_bayes_rand(1.0,mdp.A_inv, mdp.aa,
		  1.0/K, mdp.B_inv, mubar,
		  mdp.mean, p0);

    /* free memory */
    free_dvector(mubar,0,p0-1);
  } else {
    sumx(mdp.mu1,&mubar1,K);
    mubar1 *= 1.0/K;
    /* compute and sample posterior on m */
    nn_bayes1_rand(1.0,mdp.A1_inv, mdp.aa1,
		  1.0/K, 1.0/mdp.B1, mubar1,
		  &mdp.mean1);
  }
}

/* ***********************************************************
   draw B
/* *********************************************************** */
/* dummy */
/* sample B from p(B|..) =
   W(1/B; k+c, [cC + 1/tau*sum (mu[k]-m)(mu[k]-m)']^-1)
*/
void sample_B()
{ double **Sk, **S1, **S1_inv_cd,
    **B_cd, *z, Sk1, C11, Binv;
  int k,c1;

  if (p0>1){
    /* allocate memory */
    B_cd = dmatrix(0,p0-1,0,p0-1);
    Sk = dmatrix(0,p0-1,0,p0-1);
    S1 = dmatrix(0,p0-1,0,p0-1);
    S1_inv_cd = dmatrix(0,p0-1,0,p0-1);
    z = dvector(0,p0-1);
  
    /* Sk = sum (mu[k]-m)(mu[k]-m)' */
    A_zero(Sk,p0);
    for(k=0;k<mdp.n_class;k++){
      x_min_y(mdp.mu[k],mdp.mean,z,p0);
      A_plus_rxxt(Sk,1.0,z,Sk,p0);
    }

    /* S1 = s*S+Sk */
    rA_plus_sB(mdp.c*1.0, mdp.C, 1.0, Sk, S1, p0);
    cdinv(p0,S1,S1_inv_cd);
    //wishart(mdp.c+mdp.n_class, p, S1_inv_cd, mdp.B_inv);
     wishart(mdp.c+mdp.n_class, p0, S1_inv_cd, mdp.B_inv);
  
    /* compute B, B_cd, B_inv_cd etc. */
    d_chol_decomp(p0,mdp.B_inv, mdp.B_cd_inv);
    d_inv_triang(p0,mdp.B_cd_inv,B_cd);
    ABt(B_cd,p0,p0,B_cd,p0,p0,mdp.B);

    /* error check */
    // if (isnan(mdp.B[0][0])){
    //   error("sample_B", "B is NaN.", 1);
    // }

    /* allocate memory for the auxilary arrays */
    free_dmatrix(B_cd,0,p0-1,0,p0-1);
    free_dmatrix(S1,0,p0-1,0,p0-1);
    free_dmatrix(Sk,0,p0-1,0,p0-1);
    free_dmatrix(S1_inv_cd,0,p0-1,0,p0-1);
    free_dvector(z,0,p0-1);
  } else { //p0=1, univariate
    /* ******************************************************************
       CHECK THIS!!
    */
    /* B] from G(1/B; (c+K)/2, 1/2*(cC + Sk)),
       where Sk = sum (mu[i]-mean)^2   */
    /* Sk = sum (mu[k]-m)(mu[k]-m)' */
    Sk1=0;
    for(k=0;k<mdp.n_class;k++)
      Sk1 += (mdp.mu1[k]-mdp.mean1)*(mdp.mu1[k]-mdp.mean1);

    /* S1 = s*S+Sk */
    C11 = 0.5*(mdp.c*mdp.C1+Sk1);
    c1 = 0.5*(mdp.c+mdp.n_class);
    Binv = gamdev_ab(c1,C11);
    mdp.B1 = 1.0/Binv;
  }
}



/* ***********************************************************
   sample alpha
/* *********************************************************** 
   draw alpha and eta from:
   alpha from     pi*Gamma(a0+n_class, b0-log(eta)) +
              (1-pi)*Gamma(a0+n_class-1, b0-log(eta)),
         where pi = (a+n-class-1)/(a0+n_class-1 + n*b0 - n*log(eta)).
   eta   from Beta(alpha+1,n).
*/
void sample_alpha()
{
     double a,  b, pi;       /* parameters in Gamma call */
     double u;

      dbg = 0;
      if (dbg) message("sample alpha");

    //  /* draw eta */
     mdp.eta = betadev(mdp.alpha+1.0, n*1.0);
     
    //  /* compute pars for gammas for alpha */
    // if(mdp.eta>0){   
       b = mdp.b0 - log(mdp.eta);
    
   
     pi = (mdp.a0 + mdp.n_class - 1)/
       (mdp.a0 + mdp.n_class -1 + n*(mdp.b0 - log(mdp.eta)));
     duniform(1,&u);
     a = (u<pi) ? mdp.a0+mdp.n_class : mdp.a0+mdp.n_class-1;

     /* draw alpha with prob pi from Gamma(a1,b) else Gamma(a2,b) */
     mdp.alpha = gamdev_ab(a,b);

     if (dbg){
       messdouble("alpha: ",mdp.alpha);
     }
     dbg=0;

}

/* ============================================================= 
   updating the similarity parameters
/* ============================================================= */ 

void setup_mj1(int j, int k, int sample){
   /* update (mu,V) for cluster l, j-th continuous covariate */
  int i;
  double nk, ybar, mu, V, m1,s1;

  if ( (j>=p1) | (k>mdp.n_class))
    err_msg("setup_mj1","j=%d or k=%d out of range.",j,k,0);

  V = sim.V1[j];
  /* get ybar */
  nk = 1.0*mdp.count[k];
  if (nk>0){
    ybar = 0;
    for(i=mdp.first[k];i!=-1;i=mdp.next[i]){
      ybar += dta.Y[i][p0+j];
    }
    if (mdp.count[k] != 0) ybar = ybar/(1.0*nk);

    nn_bayes1(1.0, 1.0/sim.B1[j], sim.mean1[j],
	      1.0/nk, 1.0/V, ybar,
	      &s1, &m1);
  } else{
    m1=sim.mean1[j];
    s1=sim.B1[j];
  }
  sim.mj1[k][j] = m1; 
  sim.sj1[k][j] = s1;
  // ignore sample request -- don't save mu1[j]
}



void setup_pij2(int j, int k, int sample){
  /* update pi3 for cluster k, j-th categorical covariate */
  int i,h,q,nk,nj;
  int yi,*y;
  double yid, s;

  if ( (j>=p2) | (k>mdp.n_class))
    err_msg("setup_pij2","j=%d or k=%d out of range.",j,k,0);
  

  q = dta.q2[j];
  y = ivector(0,q);

  /* get ybar */
  nk = 1.0*mdp.count[k];
  nj=0; /* same as nk, for plausiblity check */
  i_zero(y,q);
  if (nk>0){
    for(i=mdp.first[k];i!=-1;i=mdp.next[i]){
      yid = dta.Y[i][p0+p1+j];
      if (yid-floor(yid) > 0)
	err_msg("setup_pi2","Y[%d,%d] is not integer!",i,p0+p1+j,0);
      yi=yid;
      if ((yi<0) | (yi>q))
	err_msg("setup_pi2","Y[%d,%d]=%d out of range for variable",
		i,p0+p1+j,yi);
      y[yi] += 1;
      nj+=1;
    }
    if (nj != nk)
      err_msg("setup_pi2","cluster %d: size=%d, does not match count[j]=%d",
	      k,nj,nk);
  }
  
  for(s=0,h=0;h<q;h++){
    sim.pij2[k][j][h] = sim.pi2[j][h]+y[h];
    s+= sim.pij2[k][j][h];
  }
  sim.pij2[k][j][q]=s; /* save sum in last element */

  free_ivector(y,0,q);

}

void setup_aj4(int j, int k, int sample){
  /* update pi3 for cluster k, j-th count covariate */
  int i,yj;
  int nj,Rj;
  double a1,b1,yjd;

  if ( (j>=p4) | (k>mdp.n_class))
    err_msg("setup_aj4","j=%d or k=%d out of range.",j,k,0);

  Rj=0;
  nj=0;
  if(mdp.count[k]>0){
    for(i=mdp.first[k];i!=-1;i=mdp.next[i]){
      yjd = dta.Y[i][p0+p1+p2+p3+j];
      if (yjd-floor(yjd) > 0)
	err_msg("setup_aj4","Y[%d,%d] is not integer!",
		i,p0+p1+p2+p3+j,0);
      yj=yjd;
      if (yjd<0)
	err_msg("setup_aj4","y=%d <0",yj,0,0);
      Rj += yjd;
      nj+=1;
    }
    if (nj != mdp.count[k])
      err_msg("setupu_aj4","cluster %d: size=%d does not match count[j]=%d",
	      k,nj,mdp.count[k]);
  }
  sim.aj4[k][j]=sim.a4[j]+Rj;
  sim.bj4[k][j]=sim.b4[j]+nj;

  //printf("sim.aj[%d][%d]: %f,%f",k,j,sim.aj4[k][j], sim.bj4[k][j] );
}


/* ============================================================= 
   printing routines
/* ============================================================= */ 

/* ***********************************************************
   print pi
/* ***********************************************************
   prints current pi's */
void print_pi()
{
     int k, j, i;

     if (seeds==0)
    {
          muFile = openAppend("mu.mdp");
          for (k = 0; k < mdp.n_class; k++){
            fprintf(muFile,"%d",iter);
            fprintf(muFile,"\t%d\t", mdp.count[k]);
            if (p0>1)
        fwriteDoubleArray(muFile, mdp.mu[k], 1, p0);
            else 
        fprintf(muFile,"%4.2f\t", mdp.mu1[k]);
          }
          fprintf(muFile,"\n");
          fclose(muFile);

          lambda_file=openAppend("lambda.mdp");
            fprintf(lambda_file,"%d\n",iter);
            for(k=0;k<mdp.n_class;k++){
                fwriteDoubleArray(lambda_file, mdp.lambda_j[k], 1, p0); 
            }
          
          fclose(lambda_file);

          copula_file=openAppend("copula.mdp");
          fprintf(copula_file,"%d\n",iter);
            for(k=0;k<mdp.n_class;k++){
              fprintf(copula_file,"%f\n", mdp.theta[k]);
            }
            fprintf(copula_file,"\n");
            for(k=0;k<mdp.n_class;k++){
              fprintf(copula_file,"%f\n", mdp.tawnpara[k]);
            }
          fclose(copula_file);

          
          VFile = openAppend("V.mdp");
          for (k = 0; k < mdp.n_class; k++){
            fprintf(VFile,"\n %4d",iter);
            fprintf(VFile,"\t %4d\n", mdp.count[k]);
            if (p0>1)
        fwriteDoubleMatrix2(VFile,mdp.V[k], p0, p0);
            else 
        fprintf(VFile,"%4.2f ", mdp.V1[k]);
          }
          fclose(VFile);

          memberFile = openAppend("member.mdp");
            fprintf(memberFile," %4d",iter);
            fprintf(memberFile," %4d \t", mdp.n_class);
            for(i=0;i<n;i++){
              fprintf(memberFile," %3d", mdp.member[i]);
            }
          
          fprintf(memberFile,"\n");
          fclose(memberFile);
          
          lsclu_member=openAppend("lsmember.mdp");
          for(i=0;i<n;i++){
            fprintf(lsclu_member," %3d", mdp.member[i]);
          }
            
          fprintf(lsclu_member,"\n");
          fclose(lsclu_member);

          if (p1>0){ //continous covariates
            mj1file=openAppend("mj1.mdp");
            fprintf(mj1file,"\n %4d %4d \n",iter,mdp.n_class);   //edited
            for(k=0;k<mdp.n_class;k++){
        fwriteDoubleArray(mj1file, sim.mj1[k], 1, p1);
        fwriteDoubleArray(mj1file, sim.sj1[k], 1, p1);
            }
            fclose(mj1file);
          }
          if (p2>0){ // categorical covariates
            pij2file=openAppend("pij2.mdp");
            fprintf(pij2file,"\n %4d %4d \n",iter,mdp.n_class);
            for(k=0;k<mdp.n_class;k++){
        for(j=0;j<p2;j++)
          fwriteDoubleArray(pij2file, sim.pij2[k][j],1,dta.q2[j]);
            } // for k
            fclose(pij2file);
          }
          if (p4>0){ // ordinal covariates
            aj4file=openAppend("aj4.mdp");
            fprintf(aj4file,"\n %4d %4d \n",iter,mdp.n_class);
            for(k=0;k<mdp.n_class;k++){
        fwriteDoubleArray(aj4file, sim.aj4[k],1,p4);
        fwriteDoubleArray(aj4file, sim.bj4[k],1,p4);
            } // for k
            fclose(aj4file);
          }
    }
    else{
      muFile = openAppend(muname);
     for (k = 0; k < mdp.n_class; k++){
       fprintf(muFile," %4d",iter);
       fprintf(muFile,"\t %4d \t", mdp.count[k]);
       if (p0>1)
	 fwriteDoubleArray(muFile, mdp.mu[k], 1, p0);
       else 
	 fprintf(muFile,"%4.2f ", mdp.mu1[k]);
     }
     fprintf(muFile,"\n");
     fclose(muFile);

      lambda_file=openAppend(lambda_name);
            fprintf(lambda_file,"%d\n",iter);
            for(k=0;k<mdp.n_class;k++){
                fwriteDoubleArray(lambda_file, mdp.lambda_j[k], 1, p0); 
            }
          
          fclose(lambda_file);

          copula_file=openAppend(copula_name);
          fprintf(copula_file,"%d\n",iter);
            for(k=0;k<mdp.n_class;k++){
              fprintf(copula_file,"%f\n", mdp.theta[k]);
            }
            fprintf(copula_file,"\n");
            for(k=0;k<mdp.n_class;k++){
              fprintf(copula_file,"%f\n", mdp.tawnpara[k]);
            }
          fclose(copula_file);
      
     VFile = openAppend(vname);
     for (k = 0; k < mdp.n_class; k++){
       fprintf(VFile,"\n %4d",iter);
       fprintf(VFile,"\t %4d\n", mdp.count[k]);
       if (p0>1)
	 fwriteDoubleMatrix2(VFile,mdp.V[k], p0, p0);
       else 
	 fprintf(VFile,"%4.2f ", mdp.V1[k]);
     }
     fclose(VFile);

     VtFile = openAppend(vtname);
     for (k = 0; k < mdp.n_class; k++){
       fprintf(VtFile,"\n %4d",iter);
       fprintf(VtFile,"\t %4d\n", mdp.count[k]);
       if (p0>1)
	 fwriteDoubleMatrix2(VtFile,mdp.Vt[k], p0, p0);
       else 
	 fprintf(VtFile,"%4.2f ", mdp.Vt1[k]);
     }
     fclose(VtFile);

     memberFile = openAppend(membername);
       fprintf(memberFile," %4d",iter);
       fprintf(memberFile," %4d \t", mdp.n_class);
       for(i=0;i<n;i++)
	 fprintf(memberFile," %3d", mdp.member[i]);
     fprintf(memberFile,"\n");
     fclose(memberFile);

     lsclu_member=openAppend(lsclu_name);
     for(i=0;i<n;i++){
       fprintf(lsclu_member," %3d", mdp.member[i]);
     }
       
     fprintf(lsclu_member,"\n");
     fclose(lsclu_member);

     if (p1>0){ //continous covariates
       mj1file=openAppend(mj1name);
       fprintf(mj1file,"\n %4d %4d ",iter,mdp.n_class);
       for(k=0;k<mdp.n_class;k++){
	 fwriteDoubleArray(mj1file, sim.mj1[k], 1, p1);
	 fwriteDoubleArray(mj1file, sim.sj1[k], 1, p1);
       }
       fclose(mj1file);
     }
     if (p2>0){ // categorical covariates
       pij2file=openAppend(pij2name);
       fprintf(pij2file,"\n %4d %4d ",iter,mdp.n_class);
       for(k=0;k<mdp.n_class;k++){
	 for(j=0;j<p2;j++)
	   fwriteDoubleArray(pij2file, sim.pij2[k][j],1,dta.q2[j]);
       } // for k
       fclose(pij2file);
     }
     if (p4>0){ // ordinal covariates
       aj4file=openAppend(aj4name);
       fprintf(aj4file,"\n %4d %4d ",iter,mdp.n_class);
       for(k=0;k<mdp.n_class;k++){
	 fwriteDoubleArray(aj4file, sim.aj4[k],1,p4);
	 fwriteDoubleArray(aj4file, sim.bj4[k],1,p4);
       } // for k
       fclose(aj4file);
     }

  }  
     
     
}

/* ***********************************************************
   print pars
/* ***********************************************************
   print current tau,alpha,eta */
void print_pars(int time)
{
  static int linect=20;
  int i,k, ct[3], k1[3];
  
  if (mdp.verbose < 2){
    printf("iter:%d:%d ",iter,mdp.n_class);
    
    if (iter % 10 == 0) printf("\n");
    return;
  }

  /* print header line if linect == 20 */
  if (linect == 20){
    if (B_prior) 
      printf("\n\n\n %5s %16s %5s ", "iter","k (count1,2,3)  ","alpha");
    else
      printf("\n\n\n %5s %16s %5s %5s ", "iter","k (count1,2,3)  ",
	     "alpha", "tau");
    for(i=0;i<p0;i++) printf("mean[%1d](S,B)    ",i);
    if (mdp.verbose){
      for(k=0;(k<3)&(k<mdp.n_class);k++) 
	for(i=0;i<p0;i++) printf("mu[%1d][%1d]    ",k,i);
      printf
	("\n----------------------------------------------------",
	 "-------------------------- \n");
      linect = 0;
    }
    printf("\n");
  }
  /* find largest 3 classes */
  k1[0] = k1[1] = k1[2] = 0;
  ct[0] = ct[1] = ct[2] = 0;
  for(k=0; k<mdp.n_class; k++){
    if (mdp.count[k] > ct[0]){
      k1[2] = k1[1];
      ct[2] = ct[1];
      k1[1] = k1[1];
      ct[1] = ct[0];
      k1[0] = k;
      ct[0] = mdp.count[k];
    }
    else if (mdp.count[k] > ct[1]){
      k1[2] = k1[1];
      ct[2] = ct[1];
      k1[1] = k;
      ct[1] = mdp.count[k];
    }
    else if (mdp.count[k] > ct[2]){
      k1[2] = k;
      ct[2] = mdp.count[k];
    }
  }

  /* print line */
  if (B_prior)
    printf(  "%5d %3d(%3d %3d %3d) %5.2f ",
	   iter,mdp.n_class,ct[0], ct[1], ct[2],
	   mdp.alpha);
  else
    printf(  "%5d %3d(%3d %3d %3d) %5.2f ",
	   iter,mdp.n_class,ct[0], ct[1], ct[2],
	     mdp.alpha);
  if (p0>1)
    for(i=0;i<p0;i++) 
      printf("%4.1f(%4.1f,%4.1f) ", mdp.mean[i], 
			     sqrt(mdp.S[i][i]), sqrt(mdp.B[i][i]));
  else 
    printf("%4.1f(%4.1f,%4.1f) ", mdp.mean1,
			     sqrt(mdp.S1), sqrt(mdp.B1));
  if (mdp.verbose){
    for(k=0;(k<3)&(k<mdp.n_class);k++){
      if (mdp.newmem[k1[k]] == (iter-1)) printf("* ");
      else printf("| ");
      if (p0>1)
	for(i=0;i<p0;i++) 
	  printf("%4.1f(%4.1f) ",
			      mdp.mu[k1[k]][i],sqrt(mdp.V[k1[k]][i][i]));
      else
	  printf("%4.1f(%4.1f) ",mdp.mu1[k1[k]],sqrt(mdp.V1[k1[k]]));
    }
  }
  printf("\n");
  linect += 1;
}


int print_allpars()
{
  int k;

  if (p0>1){
    messdoublematrix2("B ",mdp.B,p0,p0);
    messdoublematrix2("S ",mdp.S,p0,p0);
    messdoublevec("m ",mdp.mean,p0);
    for(k=0;k<mdp.n_class;k++){
      messdoublevec("mu[i] ",mdp.mu[k],p0);
      messdoublematrix2("V[j] ",mdp.V[k],p0,p0);
    }
    printf("Note: sampling seq is \t  S,config,mu,V,B,m.\n");
    printf("------------------------------------------------------- \n");
  }
}

/* ***********************************************************
   write pars
/* ***********************************************************
   print current tau,alpha,eta */
void write_pars(int time)
{
  if (seeds==0)
  {
        parFile = openAppend("par.mdp");
      fprintf(parFile,"%4d  %6.3f %6.3f %4d\n",
        iter, mdp.alpha,mdp.eta, mdp.n_class);
      fclose(parFile);
      meanFile = openAppend("mean.mdp");
      fprintf(meanFile,"%4d \t", iter);
      if (p0>1) fwriteDoubleArray(meanFile, mdp.mean, 1, p0);
      else 	    fprintf(meanFile, "%6.3f", mdp.mean1);
      fclose(meanFile);
      if (p0>1)
      {
        survfile_a = openAppend("surv-a.mdp");
        fprintf(survfile_a,"%4d %f %f\n",
          iter,mdp.hy_alpha[0], mdp.hy_alpha[1]);
        fclose(survfile_a);
        survfile_b = openAppend("surv-b.mdp");
        fprintf(survfile_b,"%4d %f %f\n",
          iter,mdp.hy_beta[0], mdp.hy_beta[1]);
          fclose(survfile_b);
      }
      
      SFile = openAppend("S.mdp");
      fprintf(SFile,"%4d \t", iter);
      if (p0>1)
        fwriteDoubleMatrix2(SFile, mdp.S, p0,p0);
      else
        fprintf(SFile, "%6.3f ", mdp.S1);
      fclose(SFile);
      if (B_prior){
        BFile = openAppend("B.mdp");
        fprintf(BFile,"%4d \t", iter);
        if (p0>1)
          fwriteDoubleMatrix2(BFile, mdp.B, p0,p0);
        else
          fprintf(BFile, "%6.3f ", mdp.B1);
        fclose(BFile);
      }
  }
  else{
     parFile = openAppend(parname);
      fprintf(parFile,"%4d  %6.3f %6.3f %4d\n",
        iter, mdp.alpha,mdp.eta, mdp.n_class);
      fclose(parFile);
      meanFile = openAppend(mean_name);
      fprintf(meanFile,"%4d \t", iter);
      if (p0>1) fwriteDoubleArray(meanFile, mdp.mean, 1, p0);
      else 	    fprintf(meanFile, "%6.3f", mdp.mean1);
      fclose(meanFile);
      if (p0>1)
      {
        survfile_a = openAppend(surva_name);
        fprintf(survfile_a,"%4d %f %f\n",
          iter,mdp.hy_alpha[0], mdp.hy_alpha[1]);
        fclose(survfile_a);
        survfile_b = openAppend(survb_name);
        fprintf(survfile_b,"%4d %f %f\n",
          iter,mdp.hy_beta[0], mdp.hy_beta[1]);
          fclose(survfile_b);
      }
      SFile = openAppend(sname);
      fprintf(SFile,"%4d \t", iter);
      if (p0>1)
        fwriteDoubleMatrix2(SFile, mdp.S, p0,p0);
      else
        fprintf(SFile, "%6.3f ", mdp.S1);
      fclose(SFile);
      if (B_prior){
        BFile = openAppend(B_name);
        fprintf(BFile,"%4d \t", iter);
        if (p0>1)
          fwriteDoubleMatrix2(BFile, mdp.B, p0,p0);
        else
          fprintf(BFile, "%6.3f ", mdp.B1);
        fclose(BFile);
      }
  }
  
  

    
}


/* ============================================================= 
  ergodic avges for group numbers
/* ============================================================= */ 

int nclass_initialized=0; /* indicator whether nclass is initialized */
double *nclass; /* accumulate number of clusters */
int max_nclass = 0;

/* ***********************************************************
   update_nclass
/* *********************************************************** */
int update_nclass()
{
  int j;

  if (nclass_initialized == 0){
    nclass = dvector(0,n);
    for (j=0;j<=n;j++)
      nclass[j] = 0.0;
    nclass_initialized = 1;
  }

  max_nclass = (mdp.n_class > max_nclass) ? mdp.n_class : max_nclass;
  nclass[mdp.n_class] += 1.0;   //in the iteration the frequency of number of clusters
}


int write_nclass()
{
  int j;
  FILE *pjfile;
  sprintf(pjname,"pj_%d.mdp",seeds);
  pjfile = openOut(pjname);
  fwriteDoubleArray(pjfile, nclass, 10, max_nclass);
  fclose(pjfile);
}

