/* ============================================================= 


/* ============================================================= 
/* ***********************************************************
   all MDP pars
/* *********************************************************** */
#include <Rdefines.h>
#ifndef CONVOLVE_C_H
#define CONVOLVE_C_H

struct MDP_PARS
{
  /* -----------------------------------------------------------
     Data & Parameters */
  /* ----------------------------------------------------------- */
  int ar;                           /* indicator for AR */
  int cens;                         /* indicator for using censoring;
				       only possible with p0=1 */
  double ***V, **mu,                /* V[i] and mu[i] */
    ***V_cd_inv,                    /* chol decomp L and L^{-1} of V */
    ***Vt, ***Vt_cd_inv, **mj,      /* posterior mean and cov matrix */
    /* for mu[j] plus V[k] */
    ***Vj;                            /* posterior cov matrix for mu[j] */
  double *V1,*mu1,*Vt1,*mj1,*Vj1,   /* specials for p0=1 */
    S1,R1_inv,B1,C1,aa1,A1_inv,
    mean1;
    
  int *updated;                     /* indicator if mj[j] is updated */
  int  s;                           /* s, **S:  base distr of DP  */
  double **S, **S_cd_inv,
    **S_inv;                          /* prior variance, chol decomp and 
				       inverse of chol decomp */
  double **R_inv;                   /* Matrix par of hyperrior on S */
  int q;                            /* df of Wishhart hyperprior on S */
  double eta,                       /* latent par for sampling of alpha */
  alpha,                            /* conc par of DP */
  a0,                               /* prior shape for alpha */
  b0;                               /* prior scale for alpha */
  double  *mean,                      
  *aa, **A_inv;                     /* hyperpars on mean */
  double **B, **B_inv, **B_cd_inv,
    **C;
  double  **clustered_Y1,**clustered_Y2, *theta, **clustered_survr1, **clustered_survr2, **lambda_j,**tawnpara;
  double* clambdaY1,*clambdaY2, *hy_alpha, *hy_beta;
  int c;
  int** id;
  
  /* -----------------------------------------------------------
     indicators for expectations & predicitves to be computed *\
  /* ----------------------------------------------------------- */
  int py;            /* 0: no, 1: yes */
  int verbose;        /* 1: full diagnostics, 0: not */

/* -----------------------------------------------------------
     simulation for true covaraites *\
  /* ----------------------------------------------------------- */

  int tr_p1;
  int tr_p2;
  /* -----------------------------------------------------------
     configuration */
  /* ----------------------------------------------------------- 
     The current configuration, i.e. number of distinct pi[i]'s 
     and classes of identical pi[i]'s is described by count, member
     and n_class.
     Notation: pi*[0],... pi*[n_class] is the list of distinct pi[i]'s.
     Of course n_class <= n_obs.
     n_class:                 number of distinct pi[i]'s.
     count[j]                 number of pi[i]'s equal to pi*[j]
     member[i]:               = j if pi[i] = pi*[j] 
     new[j]                   = r if class j was formed during
     iteration r (for debugging purposes) 
     first[j]                 = index of first obs in class j
     next[i]:                 = index of next obs in same class as obs i
     prev[i]:                 = index of previous obs in same class
     (prev[first] and next[last] = -1) 
     */ 
  int n_class, *count, *first, *member, *next, *prev,*newmem, kmax;
};
struct DTA
{ /* data structures */
  double **Y,                       /* data */
    *CY,                            /* censoring time (if delta=0) */
    *surv_rate1,
    *surv_rate2;
  int                                  /* only for cens=1 */
  *delta;                           /* indicator for censoring */   /*OS cenceored  (in our data)= 0*/
  
                                       /* only used for cens=1 */

  int *xi;                             /* new added; indicator for censoring TTF */           
  int n_obs,                        /* n obs */
    postMCMC,                                   
    p,                              /* dimension of each obs vector */
    p0,                             /* p - dim of cov vector */
    p1, 			    /* dim of continuous covariates */
    p2,                             /* dim of categorical cov */
    *q2,			    /* q2[j]=n levels of j-th cat cov */
    mx_q2,
    p3,                             /* n count covariates (not used) */
    *q3,			    /* q2[j]=n levels of j-th ord cov */
    p4;                             /* n count covariates */
};

struct SIM_PAR
{ /* parameters that describe similarity scores */
  double **mj1,**sj1,               /* pars for cont similarity */
    *mean1, *B1,                    /* same interpr as for prior on mu */
    *V1, 
    *alpha1,                        /* exponent for cont factors */
    ***pij2,                        /* categorical cov's */
    **pi2,  
    *alpha2,
    *a4,*b4,                        /* .. count covariates */
    **aj4,**bj4,
    *alpha4,
    dstar;                         /* max recorded distance -- for
				       Dahl */
  int dahl;			    /* indicator for using David
				       Dahl's model */
				       
};

/* -----------------------------------------------------------
   dummy function declarations
/* ----------------------------------------------------------- */
void dbtteppmx( SEXP lst);
void init( SEXP lst);
void init_output();
void init_config();
void reinitialize_config();
void gibbs();
void finish();
void sample_config();
void check_class();
void take_out(int ind, int postMCMC);
void add_class(int ind, int k, int init);
void  make_ybar(int k, double *ybar);
void  make_Sk(int k, double **S);
double  Ct();
void sample_mu(int k);
void sample_newV(); 
void sample_V(int k);
void new_class(int ind, double **V, double **V_cd_inv);
void sample_S();
void sample_m();
void sample_B();
void sample_alpha();
void print_pi();
void print_pars(int time);
int print_allpars();
void write_pars(int time);
int update_nclass();
int write_nclass();
void setup_mu(int k, int draw);

void sort_array(int,double*,double);

double loglik(int i, int l, double *m, double *s);
double logpr(double *x, int i, int l);
double logpr_simu(double *x, int i, int l);
void setup_mj1(int j, int k, int sample);
void setup_pij2(int j, int k, int sample);
void setup_aj4(int j, int k, int sample);
double make_Sk1(int k);
void dahl_init();
double dahl_dist(double *x1, double *x2);
double dahl_hil(double *xi, int k);
int countDistinct(int *a, int n);
#endif /* CONVOLVE_C_H */
